<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="CONTROLFILES_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="foo" 
        method="post"
        destination="/console/database/storage/controlfile" copyParams="target,type,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/controlfile/advancedPage"/>
        <uix:formValue 
          name="event" 
          value="bar"/>

        <uix:pageLayout
          titleBinding ="CONTROLFILES@controlfileBundle@servletRequest"
          >

          <%-- for breadcrumbs support; plus standard label, links, tabs, etc --%>
          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar 
                selectedIndex="1">

                  <uix:link textBinding="GENERAL@controlfileBundle@servletRequest"
                    onClick="submitForm('foo', true, {event:'generalTab'})"/>
                  <uix:link
                    textBinding="ADVANCED@controlfileBundle@servletRequest"/>
                  <uix:link textBinding="RECORD_SECTION@controlfileBundle@servletRequest"
			onClick="submitForm('foo', true, {event:'recsecTab'})"/>


              </uix:subTabBar>
            </uix:subTabs>


            <%-- start Controlfile Information section --%>

            <uix:header 
              textBinding="CONTROLFILE_INFORMATION@controlfileBundle@servletRequest">

              <uix:tableLayout cellSpacing="5">

                <uix:rowLayout>
                  <uix:styledText 
                    styleClass="OraInstructionText"
                    textBinding="CONTROLFILES_DESCRIPTION@controlfileBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="DATABASE_ID@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="DBID@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="CONTOLFILE_TYPE@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="type@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="CONTROLFILE_CREATION_DATE@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="dateCreated@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="CONTROLFILE_SEQUENCE_NUMBER@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="seqNum@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="LAST_CHANGE_NUMBER@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText" 
                      textBinding="changeNum@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="DATE_LAST_MODIFIED@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="lastBackupTime@controlfileBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:switcher childNameBinding="compatibleVersion@controlfileBean@servletRequest">
		<uix:case name="true">		
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt 
                      promptBinding="AUTOBACKUPCTRLFILES@controlfileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
		  <uix:switcher childNameBinding="autoBackUpCtrlFiles@controlfileBean@servletRequest">
                    <uix:case name="true">
			<uix:tableLayout>
			<uix:rowLayout>
			<uix:cellFormat>
                  	  <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="ENABLED@controlfileBundle@servletRequest"/>
                        </uix:cellFormat>
			<uix:cellFormat width="5">
			</uix:cellFormat>
                        <uix:cellFormat>
		          <db:link textBinding="AUTOBACKUP_DISABLE_LINK@controlfileBundle@servletRequest"
                	   destination="/console/database/rec/config?event=doLoad&pageNum=2"
                   copyParams="target,type"/> 
                        </uix:cellFormat>
                        </uix:rowLayout>
                        </uix:tableLayout>

                    </uix:case>
                    <uix:case name="false">
			<uix:tableLayout>
			<uix:rowLayout>
			<uix:cellFormat>
                  	  <uix:styledText 
                      styleClass="OraDataText"
                      textBinding="DISABLED@controlfileBundle@servletRequest"/>
                        </uix:cellFormat>
			<uix:cellFormat width="5">
			</uix:cellFormat>
                        <uix:cellFormat>
		          <db:link textBinding="AUTOBACKUP_ENABLE_LINK@controlfileBundle@servletRequest"
                	   destination="/console/database/rec/config?event=doLoad&pageNum=2"
                   copyParams="target,type"/> 
                        </uix:cellFormat>
                        </uix:rowLayout>
                        </uix:tableLayout>

                    </uix:case>
		</uix:switcher>
		    </uix:cellFormat>
              </uix:rowLayout>
		</uix:case>
		</uix:switcher>
	
              </uix:tableLayout>
            </uix:header>

            <%-- end Controlfile Information section --%>

          </uix:subTabLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
