<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SHOW_DESCRIPTION_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="foo" 
        method="post"
        destinationBinding="defaultControllerURL@controlfileBean@servletRequest" copyParams="target,type,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/controlfile/descriptionPage"/>

        <uix:pageLayout
          titleBinding="header@controlfileBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:header 
            textBinding="RECORD_SECTION_TYPE@controlfileBundle@servletRequest">

            <uix:styledText 
              styleClass="OraDataText" 
              textBinding="type@controlfileBean@servletRequest"/>

          </uix:header>
          <uix:header 
            textBinding="DESCRIPTION@controlfileBundle@servletRequest">

            <uix:styledText 
              styleClass="OraDataText" 
              textBinding="desc@servletRequest"/>

          </uix:header>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:button textBinding="OK@uixDBObjectBundle@servletRequest" 
                  destinationBinding="backURL@servletRequest"/>
              

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

