<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="CONTROLFILES_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="foo" 
        method="post"
        destination="/console/database/storage/controlfile" copyParams="target,type,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/controlfile/generalPage"/>

        <uix:pageLayout
          titleBinding ="CONTROLFILES@controlfileBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar
                selectedIndex="0">

                <uix:link
                  textBinding="GENERAL@controlfileBundle@servletRequest"/>
                <uix:link
                  textBinding="ADVANCED@controlfileBundle@servletRequest"
                  onClick="submitForm('foo', true, {event:'advancedTab'})"/>
                <uix:link
                  textBinding="RECORD_SECTION@controlfileBundle@servletRequest"
                  onClick="submitForm('foo', true, {event:'recsecTab'})"/>

              </uix:subTabBar>
            </uix:subTabs>

            <%-- Backup to Trace button --%>
            <uix:tableLayout cellSpacing="5" width="100%">
              <uix:rowLayout hAlign="right"> 
                <uix:cellFormat>
                  <uix:submitButton 
                    textBinding="BACKUP@controlfileBundle@servletRequest"
                    name="event"
                    value="backupToTrace"
                    />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <%-- start Controlfile Information section --%>
            <%-- end Controlfile Information section --%>

            <%-- start Controlfile Mirror Images section --%>
            <uix:header 
              textBinding="CONTROLFILE_MIRROR_IMAGES@controlfileBundle@servletRequest">

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:styledText 
                    styleClass="OraInstructionText"
                    textBinding="ORACLE_STRONGLY_RECOMMENDS@controlfileBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:switcher childNameBinding="fileMapSupported@controlfileBean@servletRequest">
                <uix:case name="true">
                  <oem:table 
                    name="controlfilesTableUI"
                    beanKey="controlfilesBean"
                    destination="/console/database/storage/controlfile"
                    summaryBinding="CONTROLFILE_MIRROR_IMAGES@controlfileBundle@servletRequest"
                    formSubmitted="true"
                    dataSourceProp="controlfilesTableUI"
                    width="100%"
                    >
                     <uix:tableSelection>
                      <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                          selectedIndex="0">
                      <uix:submitButton textBinding="STORAGELAYOUT@uixDBObjectBundle@servletRequest"
                                        name="event"
                                        value="storageLayoutTab"/>
                      </uix:singleSelection>
                     </uix:tableSelection>
                  </oem:table>
                </uix:case>
		
		        <uix:case name="false">
                  <oem:table 
                    name="controlfilesTableUI"
                    beanKey="controlfilesBean"
                    destination="/console/database/storage/controlfile"
                    summaryBinding="CONTROLFILE_MIRROR_IMAGES@controlfileBundle@servletRequest"
                    formSubmitted="true"
                    dataSourceProp="controlfilesTableUI"
                    width="100%"/>
		   </uix:case>
                   </uix:switcher>

            </uix:header>
            <%-- end Controlfile Mirror Images section --%>

          </uix:subTabLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
