<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="CONTROLFILES_TITLE@controlfileBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="foo" 
        method="post"
        destination="/console/database/storage/controlfile" copyParams="target,type,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/controlfile/recSectionPage"/>

        <uix:pageLayout
          titleBinding ="CONTROLFILES@controlfileBundle@servletRequest"
          >

          <%-- for breadcrumbs support; plus standard label, links, tabs, etc --%>
          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar 
                selectedIndex="2">

                  <uix:link textBinding="GENERAL@controlfileBundle@servletRequest"
                    onClick="submitForm('foo', true, {event:'generalTab'})"/>
                  <uix:link
                    textBinding="ADVANCED@controlfileBundle@servletRequest"
                  onClick="submitForm('foo', true, {event:'advancedTab'})"/>
                  <uix:link textBinding="RECORD_SECTION@controlfileBundle@servletRequest"/>

              </uix:subTabBar>
            </uix:subTabs>


            <%-- start Controlfile Record Section Information section --%>
              <uix:header 
                textBinding="CONTROLFILE_RECORD_INFORMATION@controlfileBundle@servletRequest">

              <oem:table 
                name="controlfileRecSectionsTableUI"
                beanKey="recsecBean"
                destination="/console/database/storage/controlfile" 
                formSubmitted="true"
                summaryBinding="CONTROLFILE_RECORD_INFORMATION@controlfileBundle@servletRequest"
                dataSourceProp="controlfileRecSectionsTableUI"
                width="80%">
              </oem:table>

            </uix:header>
            <%-- end Controlfile Record Section Information section --%>

          </uix:subTabLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
