<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="dfMsgs"
              class="oracle.sysman.db.rsc.stor.DatafileMsg"/>
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>

 <uix:document>
  <uix:metaContainer>
   <uix:head titleBinding="title@datafileBean@servletRequest"/>	
  </uix:metaContainer>

  <uix:body>
    <db:form name="foo" method="POST" 
             destinationBinding="destination@servletRequest"
	     copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/datafile/dbfStorageLayout"/>  

    <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:subTabLayout>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="0">
          <uix:link textBinding= "TAB_STORAGE@dfMsgs"/>
          <uix:link textBinding="FILEINFO@dbMsgs"
               	    onClick="submitForm('foo', true, {event:'fileInfoTab'})"/>
        </uix:subTabBar>
      </uix:subTabs>

	<uix:spacer height="2"/>
       <uix:tableLayout width="100%">
	<uix:rowLayout hAlign="right">
         <uix:submitButton textBinding="displayModeText@defaultBean@servletRequest" 
		   	   name="event" 
			   value="switchDisplayMode" />
	</uix:rowLayout>
       </uix:tableLayout>

     <%-- ...... which display mode we are on ......--%>

   <uix:header textBinding="topologyHeaderText@defaultBean@servletRequest" size="1">

     <uix:switcher childNameBinding="defaultDisplayMode@defaultBean@servletRequest">
      <uix:case name="true">
	<%@ include file="/database/storage/topologyHgridViewer.jsp" %>
      </uix:case>
      <uix:case name="false">
       <jsp:include page="/database/storage/topologyViewer.jsp" />
       <uix:ref refID="sharedTopology" />
      </uix:case>
     </uix:switcher>

   </uix:header>
    </uix:subTabLayout>

   </uix:pageLayout>
  </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>


