<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/remoteBrowser/remoteBrowser.js"/>
<uix:buildTree nodeID="dbfTbsSharedAtt">

  <%--uix:header textBinding="header@mainEmoBean@servletRequest"--%>
    <uix:tableLayout cellSpacing="5">

      <uix:switcher childNameBinding="osmFeasible@">
        <uix:case name="true">
          <uix:switcher childNameBinding="creating@">
            <uix:case name="true">
               <uix:rowLayout>
                  <uix:cellFormat hAlign="right">               
                  <uix:messagePrompt labeledNodeId="storageType" promptBinding="STORAGE_TYPE@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:choice name="storageType"
                     id="storageType"
                     selectedValueBinding="storageType@"
                     onChange="submitForm('foo', true, {'event':'changeType'})">
                     <uix:option textBinding="FILE_SYSTEM@DatafileBundle@servletRequest" value="FILESYSTEM"/> 
                     <uix:option textBinding="OSM_DISK_GROUP@DatafileBundle@servletRequest" value="OSM"/>
                   </uix:choice>
               </uix:rowLayout>                   
            </uix:case>
          </uix:switcher>
        </uix:case>
      </uix:switcher>

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="true">  <!-- case creating --> 
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                             
                  <uix:messagePrompt labeledNodeId="diskGroupNumber"
                                     promptBinding="DISK_GROUP@DatafileBundle@servletRequest"
                                     required="yes"/>
                  </uix:cellFormat>                                                    
                  <uix:stackLayout>

                  <%-- Changing text/lov input to drop down list:
                  <uix:textInput name="diskGroup"
                                 textBinding="diskGroup@"/>
                  <uix:messageText messageBinding="DiskGroup@errors@servletRequest"
                                   messageType="error"/> --%>

                  <%-- Start select disk group --%>
                  <uix:choice name="diskGroupNumber"  
                              id="diskGroupNumber"
                              selectedValueBinding="diskGroupNumber@"
                              shortDescBinding="DISK_GROUP@DatafileBundle@servletRequest"
                              onChange="submitForm('foo', true, {'event':'reselectDiskGroup'})">
                    <uix:contents  childDataBinding="diskGroups@">
                       <uix:option textBinding="text" 
                                   valueBinding="value"
                                   renderedBinding="rendered"/>
                    </uix:contents>
                  </uix:choice>
                  <%-- End select disk group --%>

                </uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case creating -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->
          
      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="true">  <!-- case creating --> 
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                             
                  <uix:messagePrompt labeledNodeId="template" promptBinding="TEMPLATE@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                                 
                  <uix:stackLayout><uix:contents>
                  <%-- Changing text/lov input to drop down list:
                  <uix:textInput name="template"
                                 textBinding="template@"/>
                  <uix:messageText messageBinding="Template@errors@servletRequest"
                                   messageType="error"/> --%>

                  <%-- Start select template --%>
                  <uix:choice name="template"                                               	    	    	    
                              id="template"
	                            selectedValueBinding="template@"
                              shortDescBinding="TEMPLATE@DatafileBundle@servletRequest">
                    <uix:contents childDataBinding="templates@">
                      <uix:option textBinding="text" 
                              		valueBinding="value"
                                  renderedBinding="rendered"/>
                    </uix:contents>
                  </uix:choice>
                  <%-- End select template --%>
			            <%-- <uix:tip>
			              <uix:styledText text="A default template for the current file type will be used if it is not specified."/>
			            </uix:tip> --%>
                </uix:contents></uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case creating -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="true">  <!-- case creating --> 
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                             
                  <uix:messagePrompt labeledNodeId="aliasPath" promptBinding="ALIAS_DIRECTORY@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                                 

                  <uix:stackLayout><uix:contents>
                  <%--........alias browsing wont't be supported for this release........--%>
                  <%-- uix:lovInput name="aliasPath"
                                 columns="60"
                                 textBinding="aliasPath@"/ --%>
                  <uix:textInput id="aliasPath"
                                 name="aliasPath"
                                 textBinding="aliasPath@"/>
                  <uix:messageText messageBinding="AliasPath@errors@servletRequest"
                                   messageType="error"/>
			            <%-- <uix:tip>
			              <uix:styledText text="Do not specify alias directory if a Template is already specified."/>
			            </uix:tip> --%>
                </uix:contents></uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case creating -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="true">  <!-- case creating --> 
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                             
                  <uix:messagePrompt labeledNodeId="aliasName" promptBinding="ALIAS_NAME@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                                 

                  <uix:stackLayout><uix:contents>
                  <uix:textInput name="aliasName"
                                 id="aliasName"
                                 textBinding="aliasName@"/>
                  <uix:messageText messageBinding="AliasName@errors@servletRequest"
                                   messageType="error"/>
			            <%-- <uix:tip>
			              <uix:styledText text="If an existing alias file name is specified, the Template specification will be ignored."/>
			            </uix:tip> --%>
                </uix:contents></uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case creating -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="false"> <!-- case editing -->
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt promptBinding="FILE_NAME@DatafileBundle@servletRequest"
                                     required="yes"/>
                  </uix:cellFormat>                                 
                                     
                  <uix:stackLayout>
                  <uix:link textBinding="filename@"
                          destinationBinding="asmDiskgroupLink@servletRequest"/>
                  <uix:messageText messageBinding="filename@errors@servletRequest"
                                   messageType="error"/>

                </uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case editing -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="false"> <!-- case editing -->
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt promptBinding="FILE_PATH@DatafileBundle@servletRequest"
                                     required="yes"/>
                  </uix:cellFormat>                                 
                                     
                  <uix:stackLayout>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="filepath@"/>
                  <uix:messageText messageBinding="filepath@errors@servletRequest"
                                   messageType="error"/>

                </uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case editing -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="false"> <!-- case FS -->

          <uix:switcher childNameBinding="creating@"> <!--  create/edit type switch -->
            <uix:case name="true"> <!-- case creating -->
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt labeledNodeId="filename"
                                   promptBinding="FILE_NAME@DatafileBundle@servletRequest"
                                   required="yes"/>
                </uix:cellFormat>                                                                                    
                <uix:stackLayout>
                <%-- textInput name attribute cannot have a value of "name" --%>
                  <uix:textInput name="filename"
                               id="filename"
                               columns="60"
                               textBinding="filename@"/>
                  <uix:messageText messageBinding="filename@errors@servletRequest"
                                 messageType="error"/>

                </uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case creating -->

            <uix:case name="false"> <!-- case editing -->
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt promptBinding="FILE_NAME@DatafileBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText  styleClass="OraDataText"
                                 textBinding="filename@"/>
              </uix:rowLayout>
            </uix:case> <!-- end case editing -->

          </uix:switcher> <!--  create/edit type switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="false"> <!-- case FS -->
          <uix:switcher childNameBinding="creating@"> <!--  create/edit type switch -->
            <uix:case name="true"> <!-- case creating -->
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt labeledNodeId="filepath"
                                   promptBinding="FILE_PATH@DatafileBundle@servletRequest"
                                   required="yes"/>
                </uix:cellFormat>                                                                                    
                <uix:stackLayout>

                  <uix:messageLovField name="filepath" 
                                       id="filepath"
                                       textBinding="filepath@"
                                       columns="60"
                                       searchDescBinding="FILE_PATH@DatafileBundle@servletRequest"
                                       onClick = "setDefaultDirectoryToOracleHome();startDirectoryBrowser(\'filepath\');" />

                  <uix:messageText messageBinding="filepath@errors@servletRequest"
                                 messageType="error"/>

                </uix:stackLayout>
              </uix:rowLayout>
            </uix:case> <!-- end case creating -->

            <uix:case name="false"> <!-- case editing -->
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt promptBinding="FILE_PATH@DatafileBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:styledText  styleClass="OraDataText"
                                 textBinding="filepath@"/>
              </uix:rowLayout>
            </uix:case> <!-- end case editing -->
          </uix:switcher><!-- end create/edit type switch -->
        </uix:case> 
      </uix:switcher> <!-- end storage type switch -->

      <uix:switcher childNameBinding="datafileFromTbs@">
        <uix:case name="false">
          <uix:switcher childNameBinding="creating@">
            <uix:case name="true">
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                   
                  <uix:messagePrompt labeledNodeId="tablespace"
                                  required="yes"
                                  promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                                  
                <uix:stackLayout>
                  <uix:lovField
                        name="tablespace"
                        id="tablespace"
                        textBinding="tablespace@"
                        searchDescBinding="TABLESPACE@DatafileBundle@servletRequest"
                        onClick="startLov('tablespace', 'ListTablespaceAll')"/>
                  <uix:messageText
                             messageBinding="tablespace@errors@servletRequest"
                             messageType="error"/>
             </uix:stackLayout>
            </uix:rowLayout>
            </uix:case>
            <uix:case name="false">
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
                   </uix:cellFormat>
                <uix:link textBinding="tablespace@"
                          destinationBinding="tablespaceLink@servletRequest"/>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

        </uix:case>
        <uix:case name="true">
          <!-- we got to this datafile page from the tablespace page -->
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">                                 
              <uix:messagePrompt promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:styledText  styleClass="OraDataText"
                             textBinding="tablespace@"/>
          </uix:rowLayout>
        </uix:case>
      </uix:switcher>
      
        <uix:switcher childNameBinding="osmType@"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
          <uix:switcher childNameBinding="creating@"> <!-- mode switch -->
            <uix:case name="false"> <!-- case editing -->
               <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt promptBinding="DISK_GROUP@DatafileBundle@servletRequest"/>
                   </uix:cellFormat>
                <uix:styledText  styleClass="OraDataText"
                             textBinding="diskgroupName@"/>
              </uix:rowLayout>
            </uix:case> <!-- end case editing -->
          </uix:switcher> <!-- end mode switch -->
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

             <uix:rowLayout renderedBinding="editing@">
                     <uix:cellFormat hAlign="right">                                
                     <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
                     </uix:cellFormat>                     
                <uix:flowLayout>

                 <oem:radioButton  name="datafileStatus"                          
                          selectedValueBinding="datafileStatus@"
                          textBinding="TXT_ONLINE@DatafileBundle@servletRequest"
                          value="0"/>

                  <uix:switcher childNameBinding="datafileStatus@">
                  <uix:case name="0">
                  <oem:radioButton  name="datafileStatus"                          
                          selectedValueBinding="datafileStatus@"
                          textBinding="TXT_OFFLINE@DatafileBundle@servletRequest"
                          value="1"/>
                  </uix:case>
                  <uix:case name="1">
                  <oem:radioButton name="datafileStatus"                          
                          selectedValueBinding="datafileStatus@"
                          textBinding="TXT_OFFLINE@DatafileBundle@servletRequest"
                          value="1"/>
                  </uix:case>
                  <uix:case name="2">
                  <oem:radioButton name="datafileStatus"                          
                          selectedValueBinding ="datafileStatus@"
                          textBinding="TXT_RECOVER@DatafileBundle@servletRequest"
                          value="2"/>
                  </uix:case>
                </uix:switcher>


                  </uix:flowLayout>
              </uix:rowLayout>


              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                                 
                  <uix:messagePrompt labeledNodeId="datafileSize" promptBinding= "FILE_SIZE@DatafileBundle@servletRequest"/>
                  </uix:cellFormat>                  
                <uix:stackLayout>
                  <uix:flowLayout>
                    <uix:textInput name="datafileSize"
                                   id="datafileSize"
                                   textBinding="datafileSize@"
                                   columns="10"/>
                    <oem:choice name="datafileSizeUnit"
                                shortDescBinding="FILE_SIZE_UNIT@DatafileBundle@servletRequest"
                                selectedValueBinding="datafileSizeUnit@"
                                optionsBinding="units@"/>

                  </uix:flowLayout>
                 <uix:messageText
                             messageBinding="datafileSize@errors@servletRequest"
                             messageType="error"/>

                </uix:stackLayout>
              </uix:rowLayout>

              <uix:switcher childNameBinding="datafileFromTbs@">
              <uix:case name="false">

               <uix:switcher childNameBinding="creating@">
                <uix:case name="true">
                <uix:rowLayout>
                  <uix:messagePrompt prompt=""/>
                  <uix:checkBox name="datafileReuse"
                                checkedBinding="datafileReuse@"
                                textBinding="REUSE_EXISTING_FILE@DatafileBundle@servletRequest"/>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>

              </uix:case>
              <uix:case name="true">
              <uix:switcher childNameBinding="datafileCreatingFromTbs@">
               <uix:case name="true">

              <uix:rowLayout>
                  <uix:messagePrompt prompt=""/>
                  <uix:checkBox name="datafileReuse"
                     checkedBinding="datafileReuse@"
                     textBinding="REUSE_EXISTING_FILE@DatafileBundle@servletRequest"/>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>
              </uix:case>
              </uix:switcher>



            </uix:tableLayout>
            <%-- end General section --%>

            <%-- start Storage section --%>
            <uix:header textBinding="HDR_STORAGE@DatafileBundle@servletRequest">
            <uix:checkBox name="datafileAutoExtend"
                     checkedBinding="datafileAutoExtend@"
                     textBinding="TXT_AUTO_EXTEND@DatafileBundle@servletRequest"/>

            <uix:rowLayout> 
              <uix:spacer width="20"/>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="datafileIncrement" 
                               promptBinding="EXTEND_INCREMENT@DatafileBundle@servletRequest"
                               required="no"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <uix:flowLayout>
                      <uix:textInput name="datafileIncrement"
                                 id="datafileIncrement"
                                 textBinding="datafileIncrement@"
                                 columns="8"/>
                      <oem:choice  name="datafileIncrementUnit"
                                 shortDescBinding="EXTEND_INCREMENT_UNIT@DatafileBundle@servletRequest"
                                 selectedValueBinding="datafileIncrementUnit@"
                                 optionsBinding="units@"/>
                    </uix:flowLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageText
                             messageBinding="datafileIncrement@errors@servletRequest"
                             messageType="error"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout vAlign="top">
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="EXTEND_MAX_SIZE@DatafileBundle@servletRequest"
                               required="no"/>
                  </uix:cellFormat>

                  <uix:cellFormat hAlign="left" >
                    <uix:stackLayout>
                      <oem:radioButton name="maxSizeUnlimited"                                        
                                        textBinding="TXT_UNLIMITED@DatafileBundle@servletRequest"
                                        selectedValueBinding="maxSizeUnlimited@"
                                       value="true"/>
                      <uix:flowLayout>
                        <oem:radioButton name="maxSizeUnlimited"                                        
                                        textBinding="TXT_VALUE@DatafileBundle@servletRequest"
                                        value="false"
                                        selectedValueBinding="maxSizeUnlimited@"/>

                        <uix:textInput columns="8" name="datafileMaxSize" 
                                       shortDescBinding="EXTEND_MAX_SIZE@DatafileBundle@servletRequest"
                                       textBinding="datafileMaxSize@"/>
                        <oem:choice name="datafileMaxSizeUnit" 
                                    shortDescBinding="EXTEND_MAX_SIZE_UNIT@DatafileBundle@servletRequest"
                                    selectedValueBinding="datafileMaxSizeUnit@"
                                    optionsBinding="units@"/>

                      </uix:flowLayout>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:messageText
                              messageBinding="datafileMaxSize@errors@servletRequest"
                              messageType="error"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>
          </uix:header>

    <uix:switcher childNameBinding="datafileFromTbs@">
      <uix:case name="true">
        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>
            <uix:switcher childNameBinding="creatingTbs@">
              <uix:case name="true"> 
                <uix:tip textBinding="CONTINUE_TIP_CREATE@DatafileBundle@servletRequest"/>
              </uix:case>
              <uix:case name="false">
                <uix:tip textBinding="CONTINUE_TIP@DatafileBundle@servletRequest"/>
              </uix:case>
            </uix:switcher>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
    </uix:switcher>
</uix:buildTree>
            <%--  End Storage section --%>

