<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@datafileBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>

    <db:form name="foo" method="get" destination="/console/database/storage/datafile" copyParams="target,type,cancelURL,oname,otype">

    <uix:formValue name="pageName" value="/database/storage/datafile/dbfView"/>

    <uix:pageLayout titleBinding="header@datafileBean@servletRequest">

     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
     <%@ include file="/database/global.jspf" %>

     <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

     <uix:switcher childNameBinding="osmType@datafileBean@servletRequest">     
        <uix:case name="false"> 
         <uix:labeledFieldLayout labelWidth="20%"> 
             <uix:contents>
                 <uix:messagePrompt promptBinding="NAME@DatafileBundle@servletRequest"/>
                 <uix:styledText
                            styleClass="OraDataText"
                            textBinding="datafileName@datafileBean@servletRequest"/>
            </uix:contents>
        </uix:labeledFieldLayout>
        </uix:case>
        
        <uix:case name="true"> 
         <uix:labeledFieldLayout labelWidth="20%"> 
             <uix:contents>
                 <uix:messagePrompt promptBinding="NAME@DatafileBundle@servletRequest"/>
                 <uix:link textBinding="datafileName@datafileBean@servletRequest"
                           destinationBinding="asmDiskgroupLink@servletRequest"/> 
            </uix:contents>
        </uix:labeledFieldLayout>
        </uix:case>
      </uix:switcher>
      
      <uix:labeledFieldLayout labelWidth="20%"> 
       <uix:contents>
         <uix:messagePrompt promptBinding="TABLESPACE@DatafileBundle@servletRequest"/>
         <uix:link textBinding="tablespace@datafileBean@servletRequest"
                   destinationBinding="tablespaceLink@servletRequest"/>       
       </uix:contents>
     </uix:labeledFieldLayout> 
     
      <uix:switcher childNameBinding="osmType@datafileBean@servletRequest"> <!--  Storage Type switch-->
        <uix:case name="true"> <!-- case OSM -->
             <uix:labeledFieldLayout labelWidth="20%">
                <uix:contents>                                 
                  <uix:messagePrompt promptBinding="DISK_GROUP@DatafileBundle@servletRequest"/>
                           <uix:styledText
                    styleClass="OraDataText"
                    textBinding="diskgroupName@datafileBean@servletRequest"/>
                </uix:contents>
             </uix:labeledFieldLayout>
        </uix:case>
      </uix:switcher> <!-- end storage type switch -->

     <uix:switcher childNameBinding="datafileStatus@defaultBean@servletRequest">
       <uix:case name="0">
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
             <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
             <uix:styledText
                        styleClass="OraDataText"
                        textBinding="TXT_ONLINE@DatafileBundle@servletRequest"/>
           </uix:contents>
         </uix:labeledFieldLayout> 
       </uix:case>
       <uix:case name="1">
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
             <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
             <uix:styledText
                        styleClass="OraDataText"
                        textBinding="TXT_OFFLINE@DatafileBundle@servletRequest"/>
           </uix:contents>
         </uix:labeledFieldLayout> 
       </uix:case>
       <uix:case name="2">
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
             <uix:messagePrompt promptBinding="STATUS@DatafileBundle@servletRequest"/>
             <uix:styledText
                        styleClass="OraDataText"
                        textBinding="TXT_RECOVER@DatafileBundle@servletRequest"/>
           </uix:contents>
         </uix:labeledFieldLayout> 
       </uix:case>
     </uix:switcher>

     <uix:labeledFieldLayout labelWidth="20%">
       <uix:contents>
         <uix:messagePrompt promptBinding="fileSizeWithUnitLabel@defaultBean@servletRequest"/>
         <uix:styledText
                  styleClass="OraDataText"
                  textBinding="datafileSizeView@defaultBean@servletRequest"/>

         <uix:messagePrompt promptBinding="AUTO_EXTEND@DatafileBundle@servletRequest"/>
         <uix:switcher childNameBinding="datafileAutoExtend@defaultBean@servletRequest">
           <uix:case name="true">
             <uix:styledText styleClass="OraDataText"
                             textBinding="YES@uixDBObjectBundle@servletRequest"/>
           </uix:case>
           <uix:case name="false">
             <uix:styledText styleClass="OraDataText"
                             textBinding="NO@uixDBObjectBundle@servletRequest"/>
           </uix:case>
         </uix:switcher>
       </uix:contents>
     </uix:labeledFieldLayout> 

     <uix:switcher childNameBinding="datafileAutoExtend@defaultBean@servletRequest">
       <uix:case name="true">
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
               <%--uix:messagePrompt promptBinding="EXTEND_INCREMENT@DatafileBundle@servletRequest"/--%>
               <uix:messagePrompt promptBinding="extendIncrementWithUnitLabel@defaultBean@servletRequest"/>
               <%--uix:flowLayout--%>
                 <uix:styledText
                           styleClass="OraDataText"
                           textBinding="datafileIncrementView@defaultBean@servletRequest"/>
                 <%--
                 <uix:styledText
                           styleClass="OraDataText"
                           textBinding="datafileIncrementUnit@defaultBean@servletRequest"/>
                 --%>
               <%--/uix:flowLayout--%>
            </uix:contents>
         </uix:labeledFieldLayout>
       </uix:case>
     </uix:switcher>

     <uix:switcher childNameBinding="datafileAutoExtend@defaultBean@servletRequest">
       <uix:case  name="true">
         <uix:labeledFieldLayout labelWidth="20%">
           <uix:contents>
             <%--uix:messagePrompt promptBinding="EXTEND_MAX_SIZE@DatafileBundle@servletRequest"/--%>
             <uix:messagePrompt promptBinding="extendMaxSizeWithUnitLabel@defaultBean@servletRequest"/>
             <%--uix:flowLayout--%>
               <uix:styledText
                          styleClass="OraDataText"
                          textBinding="datafileMaxSizeView@defaultBean@servletRequest"/>
               <%--
               <uix:styledText
                          styleClass="OraDataText"
                          textBinding="datafileMaxSizeUnit@defaultBean@servletRequest"/>
               --%>
             <%--/uix:flowLayout--%>
           </uix:contents>
         </uix:labeledFieldLayout>
       </uix:case>
     </uix:switcher>
       

     <uix:pageButtons>
       <uix:pageButtonBar>
         <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
         <uix:ref refID="storagePageButtonViewInclude" />
       </uix:pageButtonBar>
     </uix:pageButtons>

  </uix:pageLayout>
  </db:form>

</uix:body>
</uix:document>
</uix:renderingContext>





