<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="foo" method="post" destination="/console/database/storage/rbsegment" copyParams="target,type,cancelURL,oname,otype">
          <uix:formValue name="pageName" value="/database/storage/rbsegment/pageRbsegment"/>

          <uix:pageLayout titleBinding="header@objectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <oem:messageBox
                messageType="info" errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox
                messageType="error" errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="true">
                <uix:labeledFieldLayout labelWidth="20%">
                  <uix:contents>
                    <uix:messagePrompt
                        labeledNodeId="rbsegmentName"
                        promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"
                        required="yes"/>
                    <uix:stackLayout>
                      <uix:textInput
                          name="rbsegmentName"
                          id="rbsegmentName"
                          textBinding="rbsegmentName@objectBean@servletRequest"
                          columns="40"/>
                      <uix:messageText messageType="error" messageBinding="rbsegmentName@errors@servletRequest"/>
                    </uix:stackLayout>
                    <uix:messagePrompt
                        labeledNodeId="tablespace"
                        promptBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"
                        required="yes"/>
                    <uix:stackLayout>
                      <uix:lovField
                          name="tablespace"
                          id="tablespace"
                          shortDescBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"
                          textBinding="tablespace@rbsegmentComponent@servletRequest"
                          onClick="startLov('tablespace', 'ListTablespaceAll')"/>
                      <uix:messageText messageType="error" messageBinding="tablespace@errors@servletRequest"/>
                    </uix:stackLayout>
                    <uix:messagePrompt
                        prompt=""/>
                    <uix:checkBox
                        name="rbsegmentType"
                        checkedBinding="typeChecked@rbsegmentComponent@servletRequest"
                        textBinding="TXT_PUBLIC@uixRbsegmentBundle@servletRequest"
                        value="PUBLIC"
                        disabledBinding="editing@objectBean@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="LBL_STATUS@uixRbsegmentBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_ONLINE@uixRbsegmentBundle@servletRequest"
                          value="ONLINE"/>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_OFFLINE@uixRbsegmentBundle@servletRequest"
                          value="OFFLINE"/>
                    </uix:flowLayout>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>

              <uix:case name="false">
                <uix:labeledFieldLayout labelWidth="20%">
                  <uix:contents>
                    <uix:messagePrompt
                        promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"/>
                    <uix:styledText styleClass="OraDataText"
                        textBinding="rbsegmentName@objectBean@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"/>
                    <uix:styledText styleClass="OraDataText"
                        textBinding="tablespace@rbsegmentComponent@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="EXTENT_MANAGEMENT@uixRbsegmentBundle@servletRequest"
                        renderedBinding="version9iAndUp@objectBean@servletRequest"/>
                    <uix:styledText styleClass="OraDataText"
                        textBinding="extentManagement@rbsegmentComponent@servletRequest"
                        renderedBinding="version9iAndUp@objectBean@servletRequest"/>
                    <uix:messagePrompt prompt=""/>
                    <uix:checkBox
                        name="rbsegmentType"
                        checkedBinding="typeChecked@rbsegmentComponent@servletRequest"
                        textBinding="TXT_PUBLIC@uixRbsegmentBundle@servletRequest"
                        value="PUBLIC"
                        disabledBinding="editing@objectBean@servletRequest"/>
                    <uix:messagePrompt
                        promptBinding="LBL_STATUS@uixRbsegmentBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_ONLINE@uixRbsegmentBundle@servletRequest"
                          value="ONLINE"/>
                      <uix:radioButton
                          name="status"
                          selectedValueBinding="status@rbsegmentComponent@servletRequest"
                          textBinding="TXT_OFFLINE@uixRbsegmentBundle@servletRequest"
                          value="OFFLINE"/>
                    </uix:flowLayout>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>
            <%-- start Extents section --%>
            <uix:header textBinding="TAB_EXTENTS@uixRbsegmentBundle@servletRequest">
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                        labeledNodeId="initSize"
                        promptBinding="LBL_INIT_SIZE@uixRbsegmentBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                          name="initSize"
                          id="initSize"
                          textBinding="initSize@rbsegmentComponent@servletRequest"
                          disabledBinding="editing@objectBean@servletRequest"
                          columns="30"/>
                      <uix:choice
                          name="initSizeUnits"
                          shortDescBinding="LBL_INIT_SIZE_UNIT@uixRbsegmentBundle@servletRequest"
                          selectedValueBinding="initSizeUnits@rbsegmentComponent@servletRequest"
                          disabledBinding="editing@objectBean@servletRequest">
                        <uix:contents>
                          <uix:option
                              valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                              textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                          <uix:option
                              valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                          <uix:option
                              valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:flowLayout>
                    <uix:messageText messageType="error" messageBinding="initSize@errors@servletRequest"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                        labeledNodeId="nextSize"
                        promptBinding="LBL_NEXT_SIZE@uixRbsegmentBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                          name="nextSize"
                          id="nextSize"
                          textBinding="nextSize@rbsegmentComponent@servletRequest"
                          disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                          columns="30"/>
                      <uix:choice
                          name="nextSizeUnits"
                          disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                          shortDescBinding="LBL_NEXT_SIZE_UNIT@uixRbsegmentBundle@servletRequest"
                          selectedValueBinding="nextSizeUnits@rbsegmentComponent@servletRequest">
                        <uix:contents>
                          <uix:option
                              valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                              textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                          <uix:option
                              valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                          <uix:option
                              valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:flowLayout>
                    <uix:messageText messageType="error" messageBinding="nextSize@errors@servletRequest"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                        labeledNodeId="optSize"
                        promptBinding="LBL_OPT_SIZE@uixRbsegmentBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                            name="optSize"
                            id="optSize"
                            textBinding="optSize@rbsegmentComponent@servletRequest"
                            disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                            columns="30"/>
                      <uix:choice
                          name="optSizeUnits"
                          disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                          shortDescBinding="LBL_OPT_SIZE_UNIT@uixRbsegmentBundle@servletRequest"
                          selectedValueBinding="optSizeUnits@rbsegmentComponent@servletRequest">
                        <uix:contents>
                          <uix:option
                              valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                              textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                          <uix:option
                              valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                          <uix:option
                              valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                              textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:flowLayout>
                    <uix:messageText messageType="error" messageBinding="optSize@errors@servletRequest"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                        labeledNodeId="minimum"
                        promptBinding="LBL_MINIMUM_NUM@uixRbsegmentBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                            name="minimum"
                            id="minimum"
                            textBinding="minimum@rbsegmentComponent@servletRequest"
                            disabledBinding="editing@objectBean@servletRequest"
                            columns="40"/>
                    </uix:flowLayout>
                    <uix:messageText messageType="error" messageBinding="minimum@errors@servletRequest"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                        promptBinding="LBL_MAXIMUM_NUM@uixRbsegmentBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:radioButton
                            name="maximumOpt"
                            selectedValueBinding="maximumOpt@rbsegmentComponent@servletRequest"
                            textBinding="TXT_UNLIMITED@uixRbsegmentBundle@servletRequest"
                            disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                            value="UNLIMITED"/>
                      <uix:radioButton
                            name="maximumOpt"
                            selectedValueBinding="maximumOpt@rbsegmentComponent@servletRequest"
                            textBinding="TXT_VALUE@uixRbsegmentBundle@servletRequest"
                            disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                            value="VALUE"/>
                      <uix:stackLayout>
                        <uix:textInput
                              name="maximum"
                              shortDescBinding="LBL_MAXIMUM_NUM@uixRbsegmentBundle@servletRequest"
                              textBinding="maximum@rbsegmentComponent@servletRequest"
                              disabledBinding="isDisableExtent@rbsegmentComponent@servletRequest"
                              columns="20"/>
                        <uix:messageText messageType="error" messageBinding="maximum@errors@servletRequest"/>
                      </uix:stackLayout>
                    </uix:flowLayout>
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
            <%-- end Extents section --%>
	    
	    <%-- start Statistics section --%>
 	<uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="false">
   			<uix:header textBinding="STATISTICS@uixDBObjectBundle@servletRequest" >  
            	<uix:labeledFieldLayout labelWidth="20%">
	      			<uix:contents>	
	      				           
                 		<uix:messagePrompt
                    		promptBinding="LBL_WRAPS@uixRbsegmentBundle@servletRequest"/>
                		<uix:styledText 
                   			 styleClass="OraDataText"
                    		 textBinding="wraps@rbsegmentComponent@servletRequest"/>		    
		     			
		     			<uix:messagePrompt
                   			promptBinding="LBL_SHRINKS@uixRbsegmentBundle@servletRequest"/>
                		<uix:styledText
                    		styleClass="OraDataText"
                    		textBinding="shrinks@rbsegmentComponent@servletRequest"/>    
		    
		    			<uix:messagePrompt
                    		promptBinding="LBL_HIGH_WATER_MARK@uixRbsegmentBundle@servletRequest"/>
                		<uix:flowLayout>
                		<uix:styledText
                   		 	styleClass="OraDataText"
                    		textBinding="hwmSize@rbsegmentComponent@servletRequest"/>
						<uix:styledText
                     			 text=" "/>
                  		<uix:styledText
                      			styleClass="OraDataText"
                      			textBinding="hwmSizeUnitsView@rbsegmentComponent@servletRequest"/>    
		                 </uix:flowLayout> 
		     
		      			<uix:messagePrompt
                    		promptBinding="LBL_ACTIVE_TRANS@uixRbsegmentBundle@servletRequest"/>
                		<uix:styledText
                    		styleClass="OraDataText"
                    		textBinding="xacts@rbsegmentComponent@servletRequest"/>		    
              		</uix:contents>
            	</uix:labeledFieldLayout>
	      	</uix:header> 
 	 	</uix:case>
            	</uix:switcher>
	       	<%-- End  Statistics section --%>

            <uix:pageButtons>
              <uix:pageButtonBar>
<%--
                <uix:submitButton name="event" value="showSql"
                    textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"/>
                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:flowLayout>
                      <uix:submitButton name="event" value="cancel"
                          textBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                      <uix:spacer width="10"/>
                      <uix:submitButton name="event" value="apply"
                          textBinding="OK@uixDBObjectBundle@servletRequest"/>
                    </uix:flowLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:flowLayout>
                      <uix:submitButton name="event" value="revert"
                          textBinding="REVERT@uixDBObjectBundle@servletRequest"/>
                      <uix:spacer width="10"/>
                      <uix:submitButton name="event" value="apply"
                          textBinding="APPLY@uixDBObjectBundle@servletRequest"/>
                    </uix:flowLayout>
                  </uix:case>
                </uix:switcher>
--%>
                <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                <uix:ref refID="pageButtonInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

