<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="TITLE_SHRINK@uixRbsegmentBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="foo" method="post" destination="/console/database/storage/rbsegment" copyParams="target,type,cancelURL,oname,otype">
          <uix:formValue name="pageName" value="/database/storage/rbsegment/pageShrink"/>

          <uix:pageLayout titleBinding="TITLE_SHRINK@uixRbsegmentBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
              <oem:messageBox
                  messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:messagePrompt
                    promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="rbsegmentName@objectBean@servletRequest"/>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:radioButton
                        name="shrinkOption"
                        selectedValueBinding="shrinkOption@objectBean@servletRequest"
                        textBinding="TXT_OPT_SIZE@uixRbsegmentBundle@servletRequest"
                        value="OPTIMAL"/>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:flowLayout>
                  <uix:radioButton
                        name="shrinkOption"
                        selectedValueBinding="shrinkOption@objectBean@servletRequest"
                        textBinding="LBL_SIZE@uixRbsegmentBundle@servletRequest"
                        value="SPECIFIED"/>
                  <uix:textInput
                      name="shrinkSize"
                      shortDescBinding="LBL_SIZE@uixRbsegmentBundle@servletRequest"
                      textBinding="shrinkSize@objectBean@servletRequest"
                      columns="10"/>
                  <uix:choice
                      name="shrinkUnits"
                      shortDescBinding="LBL_SIZE_UNIT@uixRbsegmentBundle@servletRequest"
                      selectedValueBinding="shrinkUnits@objectBean@servletRequest">
                    <uix:contents>
                      <uix:option
                          valueBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"
                          textBinding="TXT_BYTES@uixRbsegmentBundle@servletRequest"/>
                      <uix:option
                          valueBinding="KBYTES@uixDBObjectBundle@servletRequest"
                          textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
                      <uix:option
                          valueBinding="MBYTES@uixDBObjectBundle@servletRequest"
                          textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
                    </uix:contents>
                  </uix:choice>
                </uix:flowLayout>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:flowLayout>
                  <uix:submitButton name="event" value="cancel"
                      textBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                  <uix:spacer width="10"/>
                  <uix:submitButton name="event" value="shrink"
                      textBinding="OK@uixDBObjectBundle@servletRequest"/>
                </uix:flowLayout>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

