<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="foo" method="post" destination="/console/database/storage/rbsegment" copyParams="target,type,cancelURL,oname,otype">
          <uix:formValue name="pageName" value="/database/storage/rbsegment/pageView"/>

          <uix:pageLayout titleBinding="header@objectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <%-- Warning/Error display --%>
            <oem:messageBox messageType="info"
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:labeledFieldLayout labelWidth="20%">
              <uix:contents>
                <uix:messagePrompt
                    promptBinding="LBL_NAME@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="rbsegmentName@objectBean@servletRequest"/>
                <uix:messagePrompt
                    promptBinding="LBL_TABLESPACE@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="tablespace@rbsegmentComponent@servletRequest"/>

                <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                  <uix:case name="false">
                    <uix:messagePrompt
                        promptBinding="EXTENT_MANAGEMENT@uixRbsegmentBundle@servletRequest"
                        renderedBinding="Version9iAndUp@rbsegmentComponent@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText"
                        textBinding="extentManagement@rbsegmentComponent@servletRequest"
                        renderedBinding="Version9iAndUp@rbsegmentComponent@servletRequest"/>
                  </uix:case>
                </uix:switcher>

                <uix:messagePrompt
                    promptBinding="LBL_PUBLIC@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="public@rbsegmentComponent@servletRequest"/>

                <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                  <uix:case name="false">
                    <uix:messagePrompt
                        promptBinding="LBL_STATUS@uixRbsegmentBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                  <uix:case name="false">
                    <uix:switcher childNameBinding="status@rbsegmentComponent@servletRequest">
                      <uix:case name="ONLINE">
                        <uix:styledText
                            styleClass="OraDataText"
                            textBinding="TXT_ONLINE@uixRbsegmentBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="OFFLINE">
                        <uix:styledText
                            styleClass="OraDataText"
                            textBinding="TXT_OFFLINE@uixRbsegmentBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:case>
                </uix:switcher>

                <uix:messagePrompt
                    promptBinding="LBL_INIT_SIZE@uixRbsegmentBundle@servletRequest"/>
                <uix:flowLayout>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="initSize@rbsegmentComponent@servletRequest"/>
                  <uix:styledText
                      text=" "/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="initSizeUnitsView@rbsegmentComponent@servletRequest"/>
                </uix:flowLayout>
                <uix:messagePrompt
                    promptBinding="LBL_NEXT_SIZE@uixRbsegmentBundle@servletRequest"/>
                <uix:flowLayout>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="nextSize@rbsegmentComponent@servletRequest"/>
                  <uix:styledText
                      text=" "/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="nextSizeUnitsView@rbsegmentComponent@servletRequest"/>
                </uix:flowLayout>
                <uix:messagePrompt
                    promptBinding="LBL_OPT_SIZE@uixRbsegmentBundle@servletRequest"/>
                <uix:flowLayout>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="optSize@rbsegmentComponent@servletRequest"/>
                  <uix:styledText
                      text=" "/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="optSizeUnitsView@rbsegmentComponent@servletRequest"/>
                </uix:flowLayout>
                <uix:messagePrompt
                    promptBinding="LBL_MINIMUM_NUM@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="minimum@rbsegmentComponent@servletRequest"/>
                <uix:messagePrompt
                    promptBinding="LBL_MAXIMUM_NUM@uixRbsegmentBundle@servletRequest"/>
                <uix:styledText
                    styleClass="OraDataText"
                    textBinding="maximum@rbsegmentComponent@servletRequest"/>
              </uix:contents>
            </uix:labeledFieldLayout>
	    
            <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
              <uix:case name="false">
	    	<%-- start Statistics section --%>
   			<uix:header textBinding="STATISTICS@uixDBObjectBundle@servletRequest" >  
            	<uix:labeledFieldLayout labelWidth="20%">
	      			<uix:contents>	
	      				           
                 		<uix:messagePrompt
                    		promptBinding="LBL_WRAPS@uixRbsegmentBundle@servletRequest"/>
                		<uix:styledText 
                   			 styleClass="OraDataText"
                    		 textBinding="wraps@rbsegmentComponent@servletRequest"/>		    
		     			
		     			<uix:messagePrompt
                   			promptBinding="LBL_SHRINKS@uixRbsegmentBundle@servletRequest"/>
                		<uix:styledText
                    		styleClass="OraDataText"
                    		textBinding="shrinks@rbsegmentComponent@servletRequest"/>    
		    
		    			<uix:messagePrompt
                    		promptBinding="LBL_HIGH_WATER_MARK@uixRbsegmentBundle@servletRequest"/>
                		 <uix:flowLayout>
                		<uix:styledText
                   		 	styleClass="OraDataText"
                    		textBinding="hwmSize@rbsegmentComponent@servletRequest"/>
						<uix:styledText
                     			 text=" "/>
                  		<uix:styledText
                      			styleClass="OraDataText"
                      			textBinding="hwmSizeUnitsView@rbsegmentComponent@servletRequest"/>    
		                 </uix:flowLayout> 
		     
		      			<uix:messagePrompt
                    		promptBinding="LBL_ACTIVE_TRANS@uixRbsegmentBundle@servletRequest"/>
                		<uix:styledText
                    		styleClass="OraDataText"
                    		textBinding="xacts@rbsegmentComponent@servletRequest"/>		    
              		</uix:contents>
            	</uix:labeledFieldLayout>
	      	</uix:header> 
	       	<%-- End  Statistics section --%>
              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
               <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                <uix:case name="false">

                <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
                <uix:ref refID="storagePageButtonViewInclude" />
               </uix:case>
               <uix:case name="true">
               <%-- OK Button --%>
               <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
                </uix:case>
               </uix:switcher>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

