<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<jsp:useBean id="redoLogBean" scope="request"
   type="oracle.sysman.emo.adm.storage.redoLog.RedoLogObject"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@redoLogBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="redologForm" 
        method="post"
        destination="/console/database/storage/redolog" copyParams="target,type,oname,otype,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/redolog/generalPage"/>

        <uix:pageLayout titleBinding="header@redoLogBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:switcher childNameBinding="creating@redoLogBean@servletRequest" >
            <uix:case name="true">
              <%---  CREATE  ---%>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      labeledNodeId="redoLogName"
                      promptBinding="GROUP_NUM@redologBundle@servletRequest"
                      required="yes" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput
                        name="redoLogName"
                        id="redoLogName"
                        textBinding="redoLogName@redoLogBean@servletRequest"
                        columns="16"/>
                      <uix:formValue
                        name="id"
                        valueBinding="redoLogName@redoLogBean@servletRequest" />
                      <uix:messageText
                        messageBinding="redoLogName@errors@servletRequest"
                        messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      labeledNodeId="fileSize"
                      promptBinding="FILE_SIZE@redologBundle@servletRequest"
                      required="yes" />
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:flowLayout>
                      <uix:textInput
                        name="fileSize"
                        id="fileSize"
                        textBinding="fileSize@redoLogBean@servletRequest"
                        columns="6"/>

                      <oem:choice
                        name="fileSizeUnit"
                        shortDescBinding="FILE_SIZE_UNIT@redologBundle@servletRequest"
                        optionsBinding="sizeUnitChoices@redoLogBean@servletRequest"
                        selectedValueBinding="fileSizeUnit@redoLogBean@servletRequest">
                      </oem:choice>
                    </uix:flowLayout>
                    <uix:messageText
                      messageBinding="fileSize@errors@servletRequest"
                      messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <%-- ..... thread # .......--%>
                <uix:rowLayout
                  renderedBinding="ops@redoLogBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      labeledNodeId="threadNum"
                      promptBinding="THREAD_NUM@redologBundle@servletRequest"
                      required="yes" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput
                        name="threadNum"
                        id="threadNum"
                        textBinding="threadNum@redoLogBean@servletRequest"
                        columns="16"/>
                        <uix:messageText
                          messageBinding="thread@errors@servletRequest"
                          messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:case>
            <uix:case name="false">
              <%---  EDIT ---%>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="GROUP_NUM@redologBundle@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:styledText
                        textBinding="redoLogName@redoLogBean@servletRequest"
                        styleClass="OraDataText"  />
                      <uix:formValue
                        name="id"
                        valueBinding="redoLogName@redoLogBean@servletRequest" />
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="FILE_SIZE@redologBundle@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:flowLayout>
                    <uix:styledText
                      textBinding="fileSize@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                    <uix:spacer width="5" />
                    <uix:styledText
                      textBinding="fileSizeUnit@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                  </uix:flowLayout>
                </uix:rowLayout>

                <%-- ..... thread # .......--%>
                <uix:rowLayout
                  renderedBinding="ops@redoLogBean@servletRequest">
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="THREAD_NUM@redologBundle@servletRequest"
                      />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="threadNum@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt
                      promptBinding="STATUS@uixDBObjectBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="status@redoLogBean@servletRequest"
                      styleClass="OraDataText"  />
                  </uix:cellFormat>
                </uix:rowLayout>
              
              </uix:tableLayout>

            </uix:case>
          </uix:switcher>

          <uix:header
            textBinding="REDO_LOG_MEMBERS@redologBundle@servletRequest">

            <%---  Create Button  ---%>
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:contents>
                    <uix:submitButton
                      textBinding="ADD@uixDBObjectBundle@servletRequest"
                      name="event"
                      value="addMember"
                    />
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <oem:table
              width="100%"
              formSubmitted="true"
              name="redoLogTableUI"
              dataSourceProp="redoLogTableUI"
              summaryBinding="REDO_LOG_MEMBERS@redologBundle@servletRequest"
              beanKey="redoLogBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              destination="/console/database/storage/redolog"
              >

              <uix:tableSelection>
                <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                  selectedIndexBinding="selectedIndex@redoLogBean@servletRequest" >

                  <uix:submitButton textBinding="STORAGELAYOUT@uixDBObjectBundle@servletRequest"
                                    name="event"
                                    value="storageLayoutTab"
                                    renderedBinding="fileMapSupported@redoLogBean@servletRequest"
                                    disabledBinding="fileMapDisabled@redoLogBean@servletRequest" />


                  <uix:submitButton
                    textBinding="EDIT@uixDBObjectBundle@servletRequest"
                    name="event"
                    value="editMember"
                    />

                  <uix:submitButton 
                    textBinding="REMOVE@redologBundle@servletRequest" 
                    name="event"
                    value="deleteMember"
                    disabled="<%= redoLogBean.getDisableDelete()%>"/>

                </uix:singleSelection>
              </uix:tableSelection>
            </oem:table>
            <uix:messageText
              messageBinding="membersTable@errors@servletRequest"
              messageType="error"/>

          </uix:header>


          <uix:pageButtons>
            <uix:pageButtonBar>
<%--

              <uix:submitButton
                name="event"
                value="showSql"
                formName="redologForm"
                textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                />

              <uix:switcher childNameBinding="creating@redoLogBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton
                      textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                      name="event" value="cancel" formName="redologForm"/>  
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton 
                      textBinding="REVERT@uixDBObjectBundle@servletRequest" 
                      name="event" value="revert" formName="redologForm"/>  
                </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="creating@redoLogBean@servletRequest">
                <uix:case name="true">
                    <uix:submitButton
                      textBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" value="createRedoLog" formName="redologForm"/>
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton 
                      textBinding="APPLY@uixDBObjectBundle@servletRequest" 
                      name="event" value="apply" formName="redologForm"/>
                </uix:case>
              </uix:switcher>
--%>
              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
