<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%---------------------------------------------------------------
 --  Redo Log page for adding a file to the group members table.
 --  Permits the user to specify the state of the REUSE clause
 --  for a file if and only if that file is being Added.
 ----------------------------------------------------------------%>

<uix:renderingContext id="renderingContext">
   <oem:setURLEncoder id="renderingContext"/>

  <%-- Bundle for ASM --%>
  <uix:bundle name="AsmBundle"
              class="oracle.sysman.db.rsc.stor.DatafileMsg"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@redoLogBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%---  Form  ---%>
      <db:form
        name="redologAddForm" 
        method="post"
        destination="/console/database/storage/redolog" copyParams="target,type,oname,otype,cancelURL">

        <%---  Page Name ---%>
        <uix:formValue 
          name="pageName" 
          value="/database/storage/redolog/redoLogAdd"/>

        <%---  Page Layout and the main Header ---%>
        <uix:pageLayout titleBinding="header@redoLogBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <%---  Message Boxes ---%>
          <oem:messageBox messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" mainTextKey="mainText"/>

          <%-----------------------------
           -  Labeled Fields
           -----------------------------%>
          <uix:tableLayout cellSpacing="5" >

          <%--........... Start ASM support ............--%>
          <%-- We only allow :
               Change Storage Type, Select Disk Group, or Select Template 
               Controls if 
               1.  an asm-type MEMBER is in creating mode or
               2.  RedoLogBean is in creating mode or 
               3.  RedoLogBean is in editing mode but 
                      member is newly added and is in editing mode--%>

          <uix:switcher childNameBinding="osmFeasible@redoLogBean@servletRequest">
            <uix:case name="true">
              <uix:switcher childNameBinding="showOsmAdv@redoLogBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">               
                      <uix:messagePrompt labeledNodeId="storageType"
                        promptBinding="STORAGE_TYPE@AsmBundle"/>
                    </uix:cellFormat>
                      <uix:choice name="storageType"
                                  id="storageType"
                                  selectedValueBinding="storageType@redoLogBean@servletRequest"
                                  onChange="submitForm('redologAddForm', true, {'event':'changeType'})">
                        <uix:option textBinding="FILE_SYSTEM@AsmBundle" value="FILESYSTEM"/> 
                        <uix:option textBinding="OSM_DISK_GROUP@AsmBundle" value="OSM"/>
                      </uix:choice>
                  </uix:rowLayout>                   
                </uix:case>
              </uix:switcher>
            </uix:case>
          </uix:switcher>

          <%-- Select Disk Group Drop-down --%>
          <uix:switcher childNameBinding="osmType@redoLogBean@servletRequest">
            <uix:case name="true">
              <uix:switcher childNameBinding="showOsmAdv@redoLogBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">                             
                      <uix:messagePrompt labeledNodeId="diskGroup"
                                         promptBinding="DISK_GROUP@AsmBundle"
                                         required="yes"/>
                    </uix:cellFormat>                                                    
                    <uix:stackLayout>
                    <uix:choice name="diskGroup"  
                                id="diskGroup"  
                                selectedValueBinding="diskGroup@redoLogBean@servletRequest"
                                shortDescBinding="DISK_GROUP@AsmBundle"
                                onChange="submitForm('redologAddForm', true, {'event':'reselectDiskGroup'})">
                      <uix:contents  childDataBinding="diskGroups@redoLogBean@servletRequest">
                         <uix:option textBinding="text" 
                                     renderedBinding="rendered"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher> 
          </uix:case>
        </uix:switcher>
          
        <%-- Select Template Drop-down --%>
        <uix:switcher childNameBinding="osmType@redoLogBean@servletRequest">
          <uix:case name="true"> 
            <uix:switcher childNameBinding="showOsmAdv@redoLogBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                             
                    <uix:messagePrompt labeledNodeId="template"
                                       promptBinding="TEMPLATE@AsmBundle"/>
                  </uix:cellFormat>                                 
                  <uix:stackLayout><uix:contents>
                    <uix:choice name="template"                                               	    	    	    
                                id="template"
	                              selectedValueBinding="template@redoLogBean@servletRequest"
                                shortDescBinding="TEMPLATE@AsmBundle">
                      <uix:contents childDataBinding="templates@redoLogBean@servletRequest">
                        <uix:option textBinding="text" 
                                		valueBinding="value"
                                    renderedBinding="rendered"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:contents></uix:stackLayout>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 
          </uix:case>
        </uix:switcher> 

            <%-- ASM: Alias Directory: Creating and Editing --%>
            <uix:switcher childNameBinding="osmType@redoLogBean@servletRequest"> 
              <uix:case name="true">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">                             
                        <uix:messagePrompt labeledNodeId="aliasPath"
                                           promptBinding="ALIAS_DIRECTORY@AsmBundle"/>
                      </uix:cellFormat>                                 

                      <uix:stackLayout><uix:contents>
                        <uix:textInput name="aliasPath"
                                       id="aliasPath"
                                       textBinding="aliasPath@redoLogBean@servletRequest"/>
                        <uix:messageText messageBinding="AliasPath@errors@servletRequest"
                                        messageType="error"/>
                      </uix:contents></uix:stackLayout>
                    </uix:rowLayout>
              </uix:case>
            </uix:switcher> 

            <%-- Asm: Alias Name: Creating --%>      
            <uix:switcher childNameBinding="osmType@redoLogBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                             
                    <uix:messagePrompt labeledNodeId="aliasName"
                                       promptBinding="ALIAS_NAME@AsmBundle"/>
                  </uix:cellFormat>                                 

                  <uix:stackLayout><uix:contents>
                    <uix:textInput name="aliasName"
                                   id="aliasName"
                                   textBinding="aliasName@redoLogBean@servletRequest"/>
                    <uix:messageText messageBinding="AliasName@errors@servletRequest"
                                     messageType="error"/>
                  </uix:contents></uix:stackLayout>
                </uix:rowLayout>
            </uix:case>
          </uix:switcher>
          <%--........... End ASM support ............--%>

          <%--............ FILESYSTEM Creating and Editing Mode ...............--%>
          <uix:switcher childNameBinding="osmType@redoLogBean@servletRequest">
            <uix:case name="false">
<%--                
                <uix:switcher childNameBinding="addedMember@redoLogBean@servletRequest">
                  <uix:case name="true">
--%>                    
                    <%--------------------------------------%>
                    <%---  Log File Name during create   ---%>
                    <%--------------------------------------%>
                    <uix:rowLayout>
                      <%---  Prompt  ---%>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt labeledNodeId="addMemberName" required="yes"
                          promptBinding="FILE_NAME@redologBundle@servletRequest"/>
                      </uix:cellFormat>

                      <%---  Field  ---%>
                      <uix:cellFormat>
                        <uix:textInput 
                          name="addMemberName" id="addMemberName"
                          textBinding="addMemberName@redoLogBean@servletRequest" columns="50"/>
                      </uix:cellFormat>

                      <uix:messageText
                        messageBinding="redoLogName@errors@servletRequest"
                        messageType="error"/>
                    </uix:rowLayout>
<%--
                  </uix:case>
                  
                  <uix:case name="false">                    
--%>
                    <%------------------------------------%>
                    <%---  Log File Name during edit   ---%>
                    <%------------------------------------%>
<%--
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">                                 
                        <uix:messagePrompt promptBinding="FILE_NAME@redologBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:styledText  styleClass="OraDataText"
                                         textBinding="addMemberName@redoLogBean@servletRequest"/>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
--%>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="osmType@redoLogBean@servletRequest">
            <uix:case name="false">
<%--
                <uix:switcher childNameBinding="addedMember@redoLogBean@servletRequest">
                  <uix:case name="true">
--%>
                    <%-------------------------------------%>
                    <%---  Directory Path during create ---%>
                    <%-------------------------------------%>
                    <uix:rowLayout>

                      <%---  Prompt  ---%>
                      <uix:cellFormat hAlign="right">
                        <uix:messagePrompt
                          labeledNodeId="addMemberPath"
                          required="yes"
                          promptBinding="FILE_DIR@redologBundle@servletRequest"/>
                      </uix:cellFormat>

                      <%---  Field  ---%>
                      <uix:cellFormat>
                        <uix:textInput 
                          name="addMemberPath"
                          id="addMemberPath"
                          textBinding="addMemberPath@redoLogBean@servletRequest"
                          columns="50"/>
                      </uix:cellFormat>

                      <uix:messageText
                        messageBinding="redoLogDir@errors@servletRequest"
                        messageType="error"/>

                    </uix:rowLayout>
<%--
                  </uix:case>
                  
                  <uix:case name="false">                    
--%>
                    <%------------------------------------%>
                    <%---  Directory Path during edit  ---%>
                    <%------------------------------------%>
<%--
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">                                 
                        <uix:messagePrompt promptBinding="FILE_DIR@redologBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:styledText  styleClass="OraDataText"
                                         textBinding="addMemberPath@redoLogBean@servletRequest"/>
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
--%>
            </uix:case>
          </uix:switcher>

            <%------------------------%>
            <%---  Reuse Setting   ---%>
            <%------------------------%>
            <uix:switcher childNameBinding="addedMember@redoLogBean@servletRequest">
              <uix:case name="true">

                <uix:rowLayout>

                  <%---  Prompt (text should be in checkbox ---%>
                  <uix:cellFormat hAlign="right">                    
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                    <uix:checkBox
                      name="addMemberReuse"
                      checkedBinding="addMemberReuse@redoLogBean@servletRequest"
                      textBinding="CHECK_REUSE@redologBundle@servletRequest"
                    />
                  </uix:cellFormat>

                </uix:rowLayout>

              </uix:case>
            </uix:switcher>

          </uix:tableLayout>


          <%---------------
           -  PageButtons
           ----------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <%---  Cancel Button  ---%>
              <uix:submitButton 
                name="event" 
                textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                value="cancelAddMember"/>  

              <%---  OK Button  ---%>
              <uix:submitButton
                name="event"
                textBinding="CONTINUE@uixDBObjectBundle@servletRequest"
                value="applyAddMember"/>  

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
