<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
 <uix:document>

  <uix:metaContainer>
   <uix:head titleBinding="title@objectBean@servletRequest"/>	
  </uix:metaContainer>

  <uix:body>
    <db:form name="foo" method="post" 
             destinationBinding="destination@servletRequest"
	     copyParams="target,type,oname,otype,cancelURL">
    <uix:formValue name="pageName" value="/database/storage/controlfile/redoLogFileInfo"/>

    <uix:pageLayout titleBinding="header@redoLogBean@servletRequest">
    
      <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="confirmation"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="1">
                <uix:link textBinding="STORAGELAYOUT@uixDBObjectBundle@servletRequest"
                   	    onClick="submitForm('foo', true, {event:'storageLayoutTab'})"/>
              	<uix:link textBinding="FILEINFO@uixDBObjectBundle@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>

       <uix:header textBinding="FILE_MAP@uixDBObjectBundle@servletRequest">

      <uix:tableLayout width="100%" cellSpacing="5">

      <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="FILE_STATUS@uixDBObjectBundle@servletRequest"/>
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left">       
	 <uix:styledText styleClass="OraDataText" textBinding="topologyFileStatus@servletRequest"/>
       </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="FILE_STRUCTURE@uixDBObjectBundle@servletRequest"/>
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left">       
        <uix:styledText styleClass="OraDataText" textBinding="topologyFileStructure@servletRequest"/>
       </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="FILE_EXTENTS@uixDBObjectBundle@servletRequest"/>
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left">       
        <uix:styledText styleClass="OraDataText" textBinding="topologyFileExtents@servletRequest"/>
       </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
       <uix:cellFormat width="20%" hAlign="right">
        <uix:messagePrompt promptBinding="MAPPED_FILE_SIZE@uixDBObjectBundle@servletRequest"/>
       </uix:cellFormat>
       <uix:cellFormat width="80%" hAlign="left">       
        <uix:styledText styleClass="OraDataText" textBinding="topologyMappedFileSize@servletRequest"/>
       </uix:cellFormat>
      </uix:rowLayout>
      </uix:tableLayout>

       <uix:tableLayout width="100%" cellSpacing="5">
        <uix:rowLayout>
	 <uix:cellFormat width="30%" hAlign="right">
          <uix:submitButton disabledBinding="mappingDisabled@defaultBean@servletRequest"
			textBinding="REFRESH_MAP@uixDBObjectBundle@servletRequest" 
			name="event" value="refreshMap"/>
	 </uix:cellFormat>
	 <uix:cellFormat width="70%" hAlign="left">
          <uix:submitButton disabledBinding="mappingDisabled@defaultBean@servletRequest"
			textBinding="DROP_MAP@uixDBObjectBundle@servletRequest" name="event" value="dropMap"/>
         </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      </uix:header>   
      </uix:subTabLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event" 
                		textBinding="OK@uixDBObjectBundle@servletRequest"
                		value="cancelPage" />  
            </uix:pageButtonBar>
          </uix:pageButtons>

    </uix:pageLayout>
   </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
