<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<jsp:useBean id="redoLogBean" scope="request"
   type="oracle.sysman.emo.adm.storage.redoLog.RedoLogObject"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@redoLogBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="redologViewForm" 
        method="get"
        destination="/console/database/storage/redolog" copyParams="target,type,oname,otype,cancelURL">

        <uix:formValue 
          name="pageName" 
          value="/database/storage/redolog/redoLogView"/>

        <uix:pageLayout titleBinding="header@redoLogBean@servletRequest">

          <%@ include file="/database/global.jspf" %>

          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout cellSpacing="5">
            
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="GROUP_NUM@redologBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:styledText
                    textBinding="redoLogName@redoLogBean@servletRequest"
                    styleClass="OraDataText"  />
                  <uix:formValue
                    name="id"
                    valueBinding="redoLogName@redoLogBean@servletRequest" />
                </uix:stackLayout>
                <uix:messageText
                  messageBinding="thread@errors@servletRequest"
                  messageType="error"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="FILE_SIZE@redologBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:flowLayout>
                <uix:styledText
                  textBinding="fileSize@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
                <uix:spacer width="5" />
                <uix:styledText
                  textBinding="fileSizeUnit@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
              </uix:flowLayout>
            </uix:rowLayout>

            <%-- ..... thread # .......--%>
            <uix:rowLayout
              renderedBinding="ops@redoLogBean@servletRequest">
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="THREAD_NUM@redologBundle@servletRequest"
                  />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="threadNum@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
                <uix:messageText
                  messageBinding="thread@errors@servletRequest"
                  messageType="error"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt
                  promptBinding="STATUS@uixDBObjectBundle@servletRequest" />
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="status@redoLogBean@servletRequest"
                  styleClass="OraDataText"  />
              </uix:cellFormat>
            </uix:rowLayout>
            
          </uix:tableLayout>

          <uix:header
            textBinding="REDO_LOG_MEMBERS@redologBundle@servletRequest">

            <oem:table 
              name="redoLogTableUI"
              width="100%"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              summaryBinding="REDO_LOG_MEMBERS@redologBundle@servletRequest"
              destination="/console/database/storage/redolog"
              formSubmitted="true" 
              beanKey="redoLogBean"
              dataSourceProp="redoLogTableUI"
              > 
            </oem:table>

          </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>

              <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
              <uix:ref refID="storagePageButtonViewInclude" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
