<%--
  -- Page:       storagePageButtonViewInclude.jsp
  -- 
  -- Description: Includes the following buttons for a view page
  --              Edit OK
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="storagePageButtonViewInclude">
<uix:tableLayout cellSpacing="5">
<uix:rowLayout>
    <%
      if (request.getAttribute("operationsChoiceBean") != null)
      { %>
        <uix:spacer width="10"/>
        <uix:cellFormat wrappingDisabled="true">
          <uix:styledText styleClass="OraPromptText"
                          textBinding="ACTIONS@uixDBObjectBundle@servletRequest"/>
        </uix:cellFormat>

        <uix:choice name="selectedOperationChoice"
                    shortDescBinding="ACTIONS@uixDBObjectBundle@servletRequest"
                    selectedValueBinding="selectedOperationChoice@operationsChoiceBean@servletRequest">
          <uix:contents childDataBinding="operationsChoiceInfo@operationsChoiceBean@servletRequest">
            <uix:option textBinding="textKey"
                        valueBinding="valueKey"/>
          </uix:contents>
        </uix:choice>
        <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="GO@uixDBObjectBundle@servletRequest" 
                          name="event" 
                          value="operationsGo"/>
      <% }
    %>
  <uix:spacer width="20"/>

  
<%-- Edit Button --%>
<uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest" 
                  shortDescBinding="EDIT@uixDBObjectBundle@servletRequest" 
                  name="event" 
                  value="editFromView" />

<%-- OK Button --%>
<uix:submitButton textBinding="RETURN@uixDBObjectBundle@servletRequest" 
                  shortDescBinding="RETURN@uixDBObjectBundle@servletRequest" 
                  name="event" 
                  value="cancel" />

<uix:spacer width="10"/>

</uix:rowLayout>
</uix:tableLayout>

</uix:buildTree>

