<%-- Confirmation page for deleting (dropping) a datafile (10.2+) --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DFMsgs"
              class="oracle.sysman.db.rsc.stor.DatafileMsg"/>
  <uix:bundle name="DBObjectMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@DBObjectMsgs"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="foo" method="post" 
               destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
               copyParams="target,type,cancelURL,oname,otype">
        <uix:formValue name="pageName" value="/database/storage/tablespace/deleteDatafileConf"/>

        <uix:pageLayout messageType="confirmation">
          
          <!-- no breadcrumbs for popups; but standard label, links, tabs, etc -->
          <%@ include file="/database/globalPopup.jspf" %>

          <uix:spacer height="10"/>

          <uix:rowLayout>
            <uix:spacer width="40"/>
            <uix:styledText styleClass="OraDataText" textBinding="dfWarnText@servletRequest" />
          </uix:rowLayout>

          <uix:spacer height="10"/>

          <uix:rowLayout>
            <uix:spacer width="40"/>
            <uix:styledText styleClass="OraInstructionText" textBinding="CONTINUE@DFMsgs" /> 
          </uix:rowLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@DBObjectMsgs" 
                          shortDescBinding="NO@DBObjectMsgs"
                          destination="javascript: history.back()" />

              <uix:submitButton textBinding="YES@DBObjectMsgs" 
	        	        shortDescBinding="YES@DBObjectMsgs"
		                name="event" value="doDeleteDatafile" />
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>        
      </db:form>    
    </uix:body>
  </uix:document>
</uix:renderingContext>
