<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:buildTree nodeID="dictionaryStoragePage">

    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
          <uix:messagePrompt labeledNodeId="initExtentSize"
                             promptBinding="INITIAL_SIZE@tablespaceBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:stackLayout>
          <uix:flowLayout>
	          <uix:textInput name="initExtentSize"
                           id="initExtentSize"
                           textBinding="initExtentSize@storageClauseBean@servletRequest"
			                     columns="10"/>

            <oem:choice name="initExtentSizeUnit"
                        shortDescBinding="INITIAL_SIZE_UNIT@tablespaceBundle@servletRequest"
                        optionsBinding="sizeUnitChoices@storageClauseUIBean@servletRequest"
                        selectedValueBinding="initExtentSizeUnit@storageClauseUIBean@servletRequest"/>
          </uix:flowLayout>
          <uix:messageText messageBinding="initExtentSize@errors@servletRequest"
                           messageType="error"/>

        </uix:stackLayout>

      </uix:rowLayout>


      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
          <uix:messagePrompt labeledNodeId="nextExtentSize"
                             promptBinding="NEXT_SIZE@tablespaceBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:stackLayout>
          <uix:flowLayout>
	          <uix:textInput  name="nextExtentSize"
                            id="nextExtentSize"
                            textBinding="nextExtentSize@storageClauseBean@servletRequest"
                            columns="10"/>

            <oem:choice name="nextExtentSizeUnit"
                        shortDescBinding="NEXT_SIZE_UNIT@tablespaceBundle@servletRequest"
                        optionsBinding="sizeUnitChoices@storageClauseUIBean@servletRequest"
                        selectedValueBinding="nextExtentSizeUnit@storageClauseUIBean@servletRequest"/>

            </uix:flowLayout>
            <uix:messageText messageBinding="nextExtentSize@errors@servletRequest"
                             messageType="error"/>
          </uix:stackLayout>
        </uix:rowLayout>

        <%-- Minimum size is valid for 8.0 and higher - no check needed here
             since inside check for 8.1 for Extent Mgmt--%>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="minExtentSize"
                               promptBinding="MINIMUM_SIZE@tablespaceBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:flowLayout>
            <uix:textInput  name="minExtentSize"
                            id="minExtentSize"
                            textBinding="minExtentSize@storageClauseBean@servletRequest"
                            columns="10"/>
            <oem:choice name="minExtentSizeUnit"
                        shortDescBinding="MINIMUM_SIZE_UNIT@tablespaceBundle@servletRequest"
                        selectedValueBinding="minExtentSizeUnit@tsStorageUIBean@servletRequest"
                        optionsBinding="sizeUnitChoices@tsStorageUIBean@servletRequest"/>
          </uix:flowLayout>
          <uix:messageText messageBinding="minExtentSize@errors@servletRequest"
                             messageType="error"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="pctIncrease"
                               promptBinding="INCREMENT_SIZE@tablespaceBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:stackLayout>
	          <uix:textInput  name="pctIncrease"
                            id="pctIncrease"
                            textBinding="pctIncrease@storageClauseBean@servletRequest"
                            columns="10"/>
            <uix:messageText messageBinding="pctIncrease@errors@servletRequest"
                             messageType="error"/>

          </uix:stackLayout>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="minExtents"
                               promptBinding="MINIMUM_NUMBER@tablespaceBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:stackLayout>

            <uix:textInput name="minExtents"
                         id="minExtents"
                         textBinding="minExtents@storageClauseBean@servletRequest"
                         columns="10"/>
            <uix:messageText messageBinding="minExtents@errors@servletRequest"
                             messageType="error"/>
          </uix:stackLayout>
        </uix:rowLayout>

        <uix:rowLayout vAlign="top">
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt promptBinding="MAXIMUM@tablespaceBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:stackLayout>
	          <oem:radioButton name="unlimitedMaxExtents"
                             value="unlimited"
                             textBinding="UNLIMITED@tablespaceBundle@servletRequest"
                             selectedValueBinding="unlimitedMaxExtents@storageClauseUIBean@servletRequest"/>
	          <uix:flowLayout>
              <oem:radioButton name="unlimitedMaxExtents"
                               value="value"
                               textBinding="VALUE@tablespaceBundle@servletRequest"
                               selectedValueBinding="unlimitedMaxExtents@storageClauseUIBean@servletRequest"/>

	            <uix:textInput name="maxExtents"
                             shortDescBinding="MAXIMUM@tablespaceBundle@servletRequest"
                             textBinding="maxExtents@storageClauseBean@servletRequest"
                             columns="10"/>
              <uix:messageText messageBinding="maxExtents@errors@servletRequest"
                             messageType="error"/>
            </uix:flowLayout>
          </uix:stackLayout>

        </uix:rowLayout>

      </uix:tableLayout>

    </uix:buildTree>


</uix:renderingContext>
