<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/database/LOV.js"/>

<script language="javascript">
<%-- Disable Offline if Undo or Locally Managed Temporary --%>
<%-- Disable Read Only if Locally Managed Temporary       --%>
<%-- Disable Bigfile if Dictionary Managed                --%>
function disableOptions()
{
  bDisable1 = document.foo.tablespaceType[2].checked;

  bDisable2 = document.foo.tablespaceType[1].checked &&
              document.foo.extentMgmtType[0].checked;
  
  
  document.foo.modeType[1].disabled = bDisable1 || bDisable2;
  document.foo.modeType[2].disabled = bDisable2;

  if (bDisable2)
  {
    document.foo.modeType[0].checked = true;
  } 
  else if (bDisable1 && document.foo.modeType[1].checked)
  {
    document.foo.modeType[0].checked = true;
  }

  if (document.foo.extentMgmtType[1].checked)
  {
    document.foo.singleDatafile.checked = false;
    document.foo.singleDatafile.disabled = true;
  }
  else
  {
    document.foo.singleDatafile.disabled = false;
  }
}
</script>         

<jsp:useBean id="datafilesBean" scope="request"
   type="oracle.sysman.emo.adm.storage.tablespace.TSDatafiles"/>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="tbspMsg"
              class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body onLoad="disableOptions()">
    <db:form name="foo" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/generalPage"/>
    <uix:formValue name="originalDefaultTemp" valueBinding="originalDefaultTemp@objectBean@servletRequest"/>
    
    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">
     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>


      <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="0">
            <uix:link textBinding="GENERAL@tablespaceBundle@servletRequest"/>
            <uix:link textBinding="STORAGE@tablespaceBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'storageTab'})"/>            
            <uix:link textBinding="THRESHOLDS@tablespaceBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'thresholdsTab'})"
                      renderedBinding="showThresholds@defaultBean@servletRequest"/>
            <uix:link textBinding="OCCUPANTS@tablespaceBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'occupantsTab'})"
                      renderedBinding="sysauxTablespace@defaultBean@servletRequest"
                      disabledBinding="sysauxOffline@defaultBean@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>

        <uix:spacer width="8"/>

        
          <%-- Tablespace name is a name value pair if we are not creating.
                 Hence the switcher--%>
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
          <uix:switcher  childNameBinding="creating@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:messagePrompt labeledNodeId="TABLESPACE_NAME"
                                 promptBinding="NAME@tablespaceBundle@servletRequest"
                                 required="yes" />
            </uix:case>
            <uix:case name="false">
              <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" 
                                 labeledNodeId="TABLESPACE_NAME"/>
            </uix:case>
          </uix:switcher>
        </uix:cellFormat>
        <uix:stackLayout>
          <uix:switcher childNameBinding="creating@objectBean@servletRequest">
            <uix:case name="true">
               <uix:textInput name="tablespaceName"
                               id="TABLESPACE_NAME"
                               textBinding="tablespaceName@defaultBean@servletRequest"
                               columns="60"/>
            </uix:case>
            <uix:case name="false">
              <uix:switcher childNameBinding="version10iOrHigher@defaultBean@servletRequest">
                <uix:case name="true">                  
                  <uix:switcher childNameBinding="sysauxTablespace@defaultBean@servletRequest">
                    <uix:case name="true">
                      <%-- If this is SYSAUX, don't allow name to be changed --%>
                      <uix:styledText  styleClass="OraDataText"
                               textBinding="tablespaceName@defaultBean@servletRequest"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:textInput name="tablespaceName"
                                   id="TABLESPACE_NAME"
                                   textBinding="tablespaceName@defaultBean@servletRequest"
                                   columns="60"/>    
                    </uix:case> 
                  </uix:switcher> 
                </uix:case>
                <uix:case name="false">
                    <uix:styledText  styleClass="OraDataText"
                               textBinding="tablespaceName@defaultBean@servletRequest"/>
                </uix:case>
              </uix:switcher>
            </uix:case>
          </uix:switcher>
          <uix:messageText messageBinding="tablespaceName@errors@servletRequest" messageType="error"/>
        </uix:stackLayout>
      </uix:rowLayout>
    

      <%-- Big File --%>
      <uix:switcher childNameBinding="notCreateand10i@defaultBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="locallyManaged@defaultBean@servletRequest">
            <uix:case name="true">    
              <uix:switcher childNameBinding="singleDatafile@defaultBean@servletRequest">
                <uix:case name="true">
      <uix:rowLayout>
         <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="BFT_LABEL@tablespaceBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="YES@uixDBObjectBundle@servletRequest"/>			
                  </uix:rowLayout>					  
               </uix:case>
                <uix:case name="false">
                  <uix:rowLayout>		    
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="BFT_LABEL@tablespaceBundle@servletRequest" />
          </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="NO@uixDBObjectBundle@servletRequest"/>	
                  </uix:rowLayout>
             </uix:case>
             </uix:switcher>
            </uix:case>			  
          </uix:switcher>
        </uix:case>
      </uix:switcher>
    </uix:tableLayout>          
          
      <%--ExtentManagement Area --%>
        <uix:tableLayout width="100%" cellSpacing="10">
          <uix:rowLayout vAlign="top">
            <uix:switcher childNameBinding="81OrHigher@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:cellFormat width="*">
                  <uix:header textBinding="EXTENT_MANAGEMENT@tablespaceBundle@servletRequest"
                              size="1">
                  <uix:switcher childNameBinding="creating@mainEmoBean@servletRequest">
                  <uix:case name="true">
                  <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                  <oem:radioButton name="extentMgmtType"
                                   disabled="false"
                                   textBinding="LOCALLY_MANAGED@tablespaceBundle@servletRequest"
                                   value="EXTENT_LOCAL"
                                   onClick='disableOptions()'
                                   selectedValueBinding="extentMgmtType@extentMgmtUIBean@servletRequest"/>

                </uix:rowLayout>
                <uix:rowLayout>
                  <oem:radioButton name="extentMgmtType"
                                   disabled="false"
                                   textBinding="DICTIONARY_MANAGED@tablespaceBundle@servletRequest"
                                   value="EXTENT_DICTIONARY"
                                   onClick='disableOptions()'
                                   selectedValueBinding="extentMgmtType@extentMgmtUIBean@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:case>
              <uix:case name="false">
              <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                  <oem:radioButton name="extentMgmtType"
                                   disabled="true"
                                   textBinding="LOCALLY_MANAGED@tablespaceBundle@servletRequest"
                                   value="EXTENT_LOCAL"
                                   selectedValueBinding="extentMgmtType@extentMgmtUIBean@servletRequest"/>

                </uix:rowLayout>
                <uix:rowLayout>
                  <oem:radioButton name="extentMgmtType"
                                   disabled="true"
                                   textBinding="DICTIONARY_MANAGED@tablespaceBundle@servletRequest"
                                   value="EXTENT_DICTIONARY"
                                   selectedValueBinding="extentMgmtType@extentMgmtUIBean@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>
              </uix:case>
              </uix:switcher>
            </uix:header>              
            </uix:cellFormat>
            </uix:case>
            </uix:switcher>
            <%--End ExtentManagement Area--%>

            <%-- Tablespace Type Area--%>
            <uix:cellFormat width="40%" >
              <uix:header textBinding="TYPE@tablespaceBundle@servletRequest"
                          size="1">

                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <oem:radioButton name="tablespaceType" 
                                     disabledBinding="permanentDisabled@defaultBean@servletRequest"
                                     textBinding="PERMANENT@tablespaceBundle@servletRequest"
                                     value="Permanent"
                                     onClick='disableOptions()'

                                     selectedValueBinding="tablespaceType@generalPageUIBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:switcher childNameBinding="version10iOrHigher@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:tableLayout cellSpacing="5">
                          <uix:rowLayout>
                          <uix:spacer width="15"/>
                          <uix:checkBox name="defaultPermanent"
                                        disabledBinding="defaultPermanentDisabled@defaultBean@servletRequest"
                                        textBinding="CHECK_DEFAULT_PERMANENT_TABLESPACE@tablespaceBundle@servletRequest"
                                        checkedBinding="defaultPermanent@defaultBean@servletRequest"/>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>


               <uix:switcher childNameBinding="version11gOrHigher@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:tableLayout cellSpacing="5">
                          <uix:rowLayout>
                          <uix:spacer width="15"/>

                           <uix:cellFormat hAlign="left">
			 <uix:messageCheckBox name="encrypt"
                                                 textBinding="ENCRYPTION@tablespaceBundle@servletRequest"
                                                 shortDescBinding="ENCRYPTION@tablespaceBundle@servletRequest"
                                                 disabledBinding="encryptedDisabled@defaultBean@servletRequest"
                                                 checkedBinding="encryptionStatus@objectBean@servletRequest"/>
                           </uix:cellFormat>
                           <%--<uix:cellFormat hAlign="right">
                            
                            <uix:messagePrompt promptBinding="ENCRYPTION@tablespaceBundle@servletRequest"/>
                           </uix:cellFormat>
                           <uix:cellFormat hAlign="left">
                            <uix:styledText styleClass="OraDataText"
                                            textBinding="encrypted@defaultBean@servletRequest"
                                            />
                           </uix:cellFormat> --%>
                           <uix:cellFormat hAlign="right">
                           <uix:submitButton name="event"
                                             textBinding="ENCRYPTION_OPT@tablespaceBundle@servletRequest"
                                             shortDescBinding="ENCRYPTION_OPT@tablespaceBundle@servletRequest"
                                             disabledBinding="encryptedDisabled@defaultBean@servletRequest"
                                             value="encryptionOption"/>
                           </uix:cellFormat>
			 </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>


                  <uix:rowLayout>
                    <oem:radioButton name="tablespaceType"
                                     textBinding="TEMPORARY@tablespaceBundle@servletRequest"
                                     value="Temporary"
                                     onClick='disableOptions()'

                                     disabledBinding="temporaryDisabled@defaultBean@servletRequest"
                                     selectedValueBinding="tablespaceType@generalPageUIBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:switcher childNameBinding="90OrHigher@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:tableLayout cellSpacing="5">
                          <uix:rowLayout>
                          <uix:spacer width="15"/>
                          <uix:checkBox name="defaultTemp"
                                        disabledBinding="defaultTempDisabled@defaultBean@servletRequest"
                                        textBinding="CHECK_DEFAULT_TEMP_TABLESPACE@tablespaceBundle@servletRequest"
                                        checkedBinding="defaultTemp@defaultBean@servletRequest"
                                        onClick="if(document.foo.originalDefaultTemp.value == 'true') submitForm('foo', true, {event:'uncheck'})"/>
                          </uix:rowLayout>
                          <uix:switcher childNameBinding="uncheckDefaultTemp@defaultBean@servletRequest">
                            <uix:case name="true">
                              <uix:rowLayout>
                                <uix:spacer width="15"/>
                                <uix:tableLayout>
                                  <uix:rowLayout>
                                  <uix:spacer width="25"/>
                                  <uix:messageLovField name="newDefaultTemp"
                                                       id="newDefaultTemp"
                                                       shortDescBinding="NEW_DEFAULT_TEMP_TABLESPACE@tbspMsg"
                                                       searchDescBinding="NEW_DEFAULT_TEMP_TABLESPACE@tbspMsg"
                                                       textBinding="newDefaultTemp@objectBean@servletRequest"
                                                       promptBinding="NEW_DEFAULT_TEMP_TABLESPACE@tbspMsg"
                                                       onClick="startLov('newDefaultTemp','ListTablespaceTemp')"
                                                       columns="20"/>
                                  </uix:rowLayout>
                                </uix:tableLayout>
                              </uix:rowLayout>
                            </uix:case>
                          </uix:switcher>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="90OrHigher@defaultBean@servletRequest">
                    <uix:case name="true">
                          <uix:rowLayout>
                            <oem:radioButton name="tablespaceType"
                                             textBinding="UNDO@tablespaceBundle@servletRequest"
                                             shortDescBinding="UNDO@tablespaceBundle@servletRequest"
                                             value="Undo"
                                             onClick='disableOptions()'
                                             selectedValueBinding="tablespaceType@generalPageUIBean@servletRequest"
                                             disabledBinding="undoDisabled@defaultBean@servletRequest"/>
                          </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="showUndoRetentionGuarantee@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:tableLayout cellSpacing="5">
                          <uix:rowLayout>
                           <uix:spacer width="20"/>
                              <uix:messagePrompt promptBinding="UNDO_RETENTION_GUARANTEE@tablespaceBundle@servletRequest"/>
                                <oem:radioButton name="undo_guarantee"
                                             textBinding="YES@tablespaceBundle@servletRequest"
                                             shortDescBinding="YES@tablespaceBundle@servletRequest"
                                             value="YES"
                                             selectedValueBinding="undoRetentionGuaranteeString@defaultBean@servletRequest" />
                                <oem:radioButton name="undo_guarantee"
                                             textBinding="NO@tablespaceBundle@servletRequest"
                                             shortDescBinding="NO@tablespaceBundle@servletRequest"
                                             value="NO"
                                             selectedValueBinding="undoRetentionGuaranteeString@defaultBean@servletRequest" />
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                                              
                  <uix:rowLayout renderedBinding="undoAssignmentEnabled@defaultBean@servletRequest">
                    <uix:flowLayout>
                        <uix:spacer width="15"/>
                        <uix:styledText labeledNodeId="assignedInstance"
                                        styleClass="OraFieldText" textBinding="ASSIGN_TO_INSTANCE@tablespaceBundle@servletRequest"/>
                        <uix:spacer width="3"/>
                        <oem:choice name="assignedInstance" 
                             id="assignedInstance" 
                             optionsBinding="allInstances@defaultBean@servletRequest"
                             selectedValueBinding="assignedInstance@defaultBean@servletRequest"/>
                    </uix:flowLayout>
                  </uix:rowLayout>

                </uix:tableLayout>
            </uix:header>
            </uix:cellFormat>

            <uix:cellFormat width="35%">
              <uix:header textBinding="STATUS@tablespaceBundle@servletRequest"
                          size="1">
                <uix:tableLayout cellSpacing="5">
                <%--If creating: 3 radio buttons available.  No choice--%>
                  <uix:rowLayout>
                    <oem:radioButton name="modeType"
                                     value="ReadWrite"
                                     disabledBinding="readWriteDisabled@defaultBean@servletRequest"
                                     textBinding="READ_WRITE@tablespaceBundle@servletRequest"
                                     selectedValueBinding="modeType@generalPageUIBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:radioButton name="modeType"
                                     value="ReadOnly"
                                     disabledBinding="readOnlyDisabled@defaultBean@servletRequest"
                                     textBinding="READ_ONLY@tablespaceBundle@servletRequest"
                                     selectedValueBinding="modeType@generalPageUIBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <oem:radioButton name="modeType"
                                     value="Offline"
                                     disabledBinding="offlineDisabled@defaultBean@servletRequest"
                                     textBinding="OFFLINE@tablespaceBundle@servletRequest"
                                     selectedValueBinding="modeType@generalPageUIBean@servletRequest"/>
                  </uix:rowLayout>

                  <uix:switcher childNameBinding="localAndTemp@defaultBean@servletRequest">
                    <uix:case name="false">
                      <uix:switcher  childNameBinding="creating@defaultBean@servletRequest">
                        <uix:case name="false">
                          <uix:rowLayout hAlign="start">
                            <uix:flowLayout>
                              <uix:spacer width="15"/>
                              <uix:messagePrompt labeledNodeId="offlineMode"
                                                 promptBinding="OFFLINE_MODE@tablespaceBundle@servletRequest"/>
                              <uix:spacer width="3"/>
                              <oem:choice name="offlineMode"
                                        id="offlineMode"
                                        disabledBinding="currentlyOffline@generalPageUIBean@servletRequest"
                                        selectedValueBinding="offlineMode@generalPageUIBean@servletRequest"
                                        optionsBinding="offlineModes@generalPageUIBean@servletRequest"/>
                            </uix:flowLayout>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>

                </uix:tableLayout>
               </uix:header>                
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>


          <uix:header textBinding="DATAFILES@tablespaceBundle@servletRequest" size="1">
            <uix:switcher childNameBinding="createand10i@defaultBean@servletRequest">
               <uix:case name="true">
                  <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:checkBox
                        name="singleDatafile"
                        disabledBinding="disablesftineditmode@defaultBean@servletRequest"
                        checkedBinding="singleDatafile@defaultBean@servletRequest"
                        textBinding="SINGLE_DATAFILE@tablespaceBundle@servletRequest" />
                  </uix:rowLayout>
                  
                  <uix:rowLayout>                                       
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="BFT_HINT@tablespaceBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>                                                         
                  </uix:tableLayout>                  
               </uix:case>
            </uix:switcher>
            
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:rowLayout hAlign="left">
                  <uix:cellFormat>
                    <uix:messageText messageBinding="datafilesTable@errors@servletRequest"
                               messageType="error"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat>
                    <uix:submitButton textBinding="ADD@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="addDatafile"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:rowLayout>              
            </uix:tableLayout>              

            <uix:stackLayout>
              <oem:table name="datafilesTable"
                         width="100%"
                         formSubmitted="true"
                         dataSourceProp="datafilesTable"
                         summaryBinding="DATAFILES@tablespaceBundle@servletRequest"
                         beanKey="datafilesUIBean" copyParams="target,type,oname"
                         alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
                <uix:tableSelection>

                  <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                                       selectedIndex="0">
                    <uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest"
                                      name="event"
                                      value="editDatafile"/>
                    <uix:submitButton textBinding="REMOVE@SDKBundle@servletRequest"
                                      name="event"
                                      value="deleteDatafile"
                                      disabled="<%= datafilesBean.getDisableDelete()%>"/>
                  </uix:singleSelection>
                </uix:tableSelection>
              </oem:table>
            </uix:stackLayout>
            </uix:header>

          </uix:subTabLayout>
          

          <uix:pageButtons>
            <uix:pageButtonBar>
              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:body>

     </uix:document>
    </uix:renderingContext>

