<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
    </uix:metaContainer>

    <db:form name="foo" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/inlineDatafilePage"/>

    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">

    <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
    
    <% if (request.getAttribute("em2goApp") != null) {%>
         <%@ include file="/em2go/em2goGlobal.jspf" %>
         <%@ include file="/em2go/em2goFooter.jspf" %>
         
    <% } else {%>   
        <%@ include file="/database/global.jspf" %>
     <%} %>
    
    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- start General & Storage section --%>
    <uix:dataScope currentDataBinding="dbfBeanfromTbs@servletRequest">
    <jsp:include page="/database/storage/datafile/dbfTbsSharedAtt.jsp" />
      <uix:ref refID="dbfTbsSharedAtt" />
    </uix:dataScope>
      <%-- End General & Storage section --%>

      <%-- start buttons section --%>
      <uix:pageButtons>
        
          <uix:switcher childNameBinding="addDatafileFromTablespaceSearch@dbfBeanfromTbs@servletRequest">
            <uix:case name="true">
              <uix:pageButtonBar>      
              <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
                                name="event"
                                value="showSql"
                                formName="foo"/>
                
                <uix:submitButton name="event" value="cancelEditDatafile" textBinding="CANCEL@uixDBObjectBundle@servletRequest" />
                <uix:submitButton name="event" value="applyEditDatafile"
                             textBinding="OK@uixDBObjectBundle@servletRequest"
                              formName="foo"/>
                </uix:pageButtonBar>
            </uix:case>
            <uix:case name="false">              
                <uix:pageButtonBar>
                <uix:submitButton name="event" value="cancelEditDatafile" textBinding="CANCEL@uixDBObjectBundle@servletRequest" />
                <uix:submitButton name="event" value="applyEditDatafile"
                             textBinding="CONTINUE@uixDBObjectBundle@servletRequest"
                              formName="foo"/>
                </uix:pageButtonBar>
            </uix:case>
          </uix:switcher>          

      </uix:pageButtons>
      <%-- end buttons section --%>

    </uix:pageLayout>
  </db:form>

</uix:document>
</uix:renderingContext>


