<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:buildTree nodeID="localStoragePage">

  <uix:header textBinding="EXTENT_ALLOCATION@tablespaceBundle@servletRequest" size="1">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <uix:switcher childNameBinding="extentAllocationDisabled@mainEmoBean@servletRequest">
          <uix:case name="false">
            <uix:stackLayout>
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <oem:radioButton name="localExtentMgmtType"
                                   value="automatic"
                                   textBinding="AUTOMATIC_ALLOCATION@tablespaceBundle@servletRequest"
                                   selectedValueBinding="localExtentMgmtType@extentMgmtUIBean@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <oem:radioButton name="localExtentMgmtType"
                                   value="uniform"
                                   textBinding="UNIFORM_ALLOCATION@tablespaceBundle@servletRequest"
                                   selectedValueBinding="localExtentMgmtType@extentMgmtUIBean@servletRequest"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:spacer width="20"/>
                  <uix:messagePrompt labeledNodeId="uniAllocSize"
                                     promptBinding="SIZE@tablespaceBundle@servletRequest"/>
                  <uix:textInput name="uniAllocSize"
                                 id="uniAllocSize"
                                 textBinding="uniAllocSize@extentMgmtBean@servletRequest"
                                 columns="15"/>
                  <oem:choice name="uniAllocSizeUnit"
                              shortDescBinding="SIZE_UNIT@tablespaceBundle@servletRequest"
                              optionsBinding="sizeUnitChoices@extentMgmtUIBean@servletRequest"
                              selectedValueBinding="uniAllocSizeUnit@extentMgmtUIBean@servletRequest"/>

                  <uix:messageText messageBinding="uniAllocSize@errors@servletRequest"
                                   messageType="error"/>

                </uix:rowLayout>
              </uix:tableLayout>
            </uix:stackLayout>
          </uix:case>
          <uix:case name="true">  <%-- Not creating.. Cannot be changed--%>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="ALLOCATION_TYPE@tablespaceBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:switcher  childNameBinding="autoAllocation@extentMgmtUIBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="AUTOMATIC_ALLOCATION@tablespaceBundle@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="UNIFORM_ALLOCATION@tablespaceBundle@servletRequest"/>
                  </uix:case>

                </uix:switcher>
              </uix:rowLayout>

              <uix:switcher childNameBinding="autoAllocation@extentMgmtUIBean@servletRequest">
                <uix:case name="false">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt promptBinding="sizeWithUnitLabel@extentMgmtBean@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:styledText  styleClass="OraDataText"
                                       textBinding="uniAllocSize@extentMgmtBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
          </uix:case>
        </uix:switcher>
      </uix:rowLayout>
      </uix:tableLayout>
      </uix:header>

      <%--Segment space management--%>
      <uix:switcher childNameBinding="localAndTemp@mainEmoBean@servletRequest">
      <uix:case name="false">  <%--If it is not local and temporary--%>
      <uix:switcher childNameBinding="undo@mainEmoBean@servletRequest">
      <uix:case name="false">   <%--If it is not Undo either--%>
      <uix:header textBinding="SEGMENT_SPACE_MANAGEMENT@tablespaceBundle@servletRequest"
                  size="1">
        <uix:tableLayout cellSpacing="5">
          <uix:switcher childNameBinding="creating@mainEmoBean@servletRequest">
            <uix:case name="true">  <%--We are creating --%>
              <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <oem:radioButton name="autoSegmentSpaceMgmt"
                                 value="true"
                                 textBinding="AUTOMATIC@tablespaceBundle@servletRequest"
                                 selectedValueBinding="autoSegmentSpaceMgmt@extentMgmtBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:spacer width="15"/>
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="SEGMENT_SPACE_MANAGEMENT_AUTOMATIC_HINT@tablespaceBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <oem:radioButton name="autoSegmentSpaceMgmt"
                                 value="false"
                                 textBinding="MANUAL@tablespaceBundle@servletRequest"
                                 selectedValueBinding="autoSegmentSpaceMgmt@extentMgmtBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                  <uix:spacer width="15"/>
                  <uix:styledText styleClass="OraInlineInfoText" textBinding="SEGMENT_SPACE_MANAGEMENT_MANUAL_HINT@tablespaceBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
                          </uix:case>
            <uix:case name="false">  <%--We are editing--%>
              <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:messagePrompt promptBinding="TYPE@tablespaceBundle@servletRequest"/>
                <uix:switcher childNameBinding="autoSegmentSpaceMgmt@extentMgmtBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="AUTOMATIC@tablespaceBundle@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="MANUAL@tablespaceBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>
        </uix:tableLayout>
      </uix:header>
      </uix:case>
      </uix:switcher>
      </uix:case>
      </uix:switcher>
      <%-- End Segment space management--%>

  </uix:buildTree>
</uix:renderingContext>

