<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="foo" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/moveOccupantDestinationPage"/>
    
    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">
     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:labeledFieldLayout labelWidth="25%">
        <uix:messagePrompt promptBinding="OCCUPANT@tablespaceBundle@servletRequest"/>        
        <uix:styledText styleClass="OraDataText"
                      textBinding="occupantDescription@occupantMoveBean@servletRequest"/>

        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>        
        <uix:styledText styleClass="OraDataText"
                      textBinding="occupantSchema@occupantMoveBean@servletRequest"/>

        <uix:messagePrompt promptBinding="SOURCE_TABLESPACE@tablespaceBundle@servletRequest"/>
        <uix:styledText styleClass="OraDataText"
                      textBinding="sourceTablespace@occupantMoveBean@servletRequest"/>

        <uix:messagePrompt promptBinding="SPACE_USED_MB@tablespaceBundle@servletRequest"/>        
        <uix:styledText styleClass="OraDataText"
                      textBinding="spaceUsedString@occupantMoveBean@servletRequest"/>
      </uix:labeledFieldLayout>

      <uix:spacer width="8"/>
      <uix:spacer width="8"/>
      <uix:tableLayout>        
        <uix:messagePrompt promptBinding="TO_WHAT_TABLESPACE@tablespaceBundle@servletRequest"/>
      </uix:tableLayout>
      

      <uix:labeledFieldLayout labelWidth="25%">
        <uix:messagePrompt labeledNodeId="destinationTablespace"
                           promptBinding="DESTINATION_TABLESPACE@tablespaceBundle@servletRequest" required="yes"/>
        <uix:lovField
                    name="destinationTablespace"
                    id="destinationTablespace"
                    searchDescBinding="DESTINATION_TABLESPACE@tablespaceBundle@servletRequest"
                    columns="30"
                    textBinding="destinationTablespace@occupantMoveBean@servletRequest"
                    onClick="startLov('destinationTablespace','ListTablespaceAll')"/>
      </uix:labeledFieldLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              
                <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                                  name="event"
                                  value="cancelMoveOccupant"
                                  formName="foo"/>
                <uix:submitButton textBinding="CONTINUE@uixDBObjectBundle@servletRequest"
                                  name="event"
                                  value="continueMoveOccupant"
                                  formName="foo"/>
                
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:body>

     </uix:document>
    </uix:renderingContext>

