<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="foo" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/moveOccupantSchedulePage"/>
    
    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">
     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:pageStatus>
	      <uix:styledText 	styleClass="OraInstructionText"
			    textBinding="JOB_TEXT@tablespaceBundle@servletRequest"/>
      </uix:pageStatus>

      <uix:contents>
       <uix:stackLayout>
        <uix:contents>
	       <%--.................. job ...................--%>	
	       <uix:header textBinding="JOB_PARAMETERS@tablespaceBundle@servletRequest">
	        <uix:contents>

	         <uix:tableLayout width="100%">
	          <uix:rowLayout>
	           <uix:cellFormat hAlign="right" width="20%">              
	            <uix:messagePrompt labeledNodeId="jobName"
                                 promptBinding="JOB_NAME@tablespaceBundle@servletRequest" required="yes"/>                
	           </uix:cellFormat>
	            <uix:spacer width="5"/>
	           <uix:cellFormat hAlign="left" width="80%">
              <uix:stackLayout>
	             <uix:textInput name="jobName" id="jobName" columns="60"
			           textBinding="jobName@occupantMoveBean@servletRequest"/>
               <uix:messageText messageType="error" messageBinding="jobName@errors@servletRequest"/>
              </uix:stackLayout> 
	           </uix:cellFormat>
	          </uix:rowLayout>
            
	          <uix:rowLayout>
	           <uix:cellFormat hAlign="right" width="20%">
	            <uix:messagePrompt labeledNodeId="jobDescription"
                                 promptBinding="JOB_DESCRIPTION@tablespaceBundle@servletRequest"/>
	           </uix:cellFormat>
	            <uix:spacer width="5"/>
	           <uix:cellFormat hAlign="left" width="80%">
	            <uix:textInput name="jobDescription"
                 id="jobDescription"
			           textBinding="jobDescription@occupantMoveBean@servletRequest"
			  	   columns="60" />
	           </uix:cellFormat>
	          </uix:rowLayout>
	         </uix:tableLayout>

	        </uix:contents>
	       </uix:header>

       <%--...................... schedule .......................--%>

       <uix:header textBinding="JOB_SCHEDULE@tablespaceBundle@servletRequest">
          <%@ include file="/sdk/schedule/start.jspf" %>       
       </uix:header>


            <uix:tableLayout width="100%" cellSpacing="10">
              <uix:rowLayout vAlign="top">
                <uix:cellFormat width="50%">                  
                  <uix:header textBinding="HOST_CREDENTIALS@tablespaceBundle@servletRequest">
                    <%@ include file="/dbhostcreds.jspf" %>                                  
                  </uix:header>                
                </uix:cellFormat>

                <uix:cellFormat width="50%">
                  <uix:header textBinding="DB_CREDENTIALS@tablespaceBundle@servletRequest">
                    <%@ include file="/credentials.jspf" %>                                    
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

         </uix:contents>
        </uix:stackLayout>
       </uix:contents>
      
          

          <uix:pageButtons>
            <uix:pageButtonBar>
              
                <uix:button       textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                                  destinationBinding="cancelURL@servletRequest"/>
                <uix:submitButton textBinding="BACK@uixDBObjectBundle@servletRequest"
                                  name="event"
                                  value="backMoveOccupant"
                                  formName="foo"/>
                <uix:submitButton textBinding="SUBMIT@tablespaceBundle@servletRequest"
                                  name="event"
                                  value="submitMoveOccupant"
                                  formName="foo"/>
                
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:body>

     </uix:document>
    </uix:renderingContext>

