<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form name="foo" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
          <uix:formValue name="pageName" value="/database/storage/tablespace/moveOccupantSuccessPage"/>

          <uix:pageLayout titleBinding="STATUS@DBObjectBundle@servletRequest">
            <%@ include file="/database/global.jspf" %>
<%--
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText" textBinding="JOB_SUCCESSFULLY_SUBMITTED@tablespaceBundle@servletRequest"/>
                <uix:styledText styleClass="OraInstructionText" textBinding="YOU_CAN_VIEW_JOB@tablespaceBundle@servletRequest"/>
              </uix:contents>
            </uix:stackLayout>
--%>
            <oem:messageBox messageType="info" 
                                 errorTableBinding="info@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                                 errorTableBinding="errors@servletRequest"
                                 titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="VIEW_JOB@tablespaceBundle@servletRequest" destinationBinding="jobSummary@occupantMoveBean@servletRequest"/>
                <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                                  name="event"
                                  value="cancelMoveOccupant"
                                  formName="foo"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
