<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="foo" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/occupantsPage"/>
    
    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">
     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>


      <uix:subTabLayout>
        <uix:subTabs>
          <uix:subTabBar selectedIndex="3">
            <uix:link textBinding="GENERAL@tablespaceBundle@servletRequest"
              onClick="submitForm('foo', true, {event:'generalTab'})"/>
            <uix:link textBinding="STORAGE@tablespaceBundle@servletRequest"
              onClick="submitForm('foo', true, {event:'storageTab'})"/>
            <uix:link textBinding="THRESHOLDS@tablespaceBundle@servletRequest"
              onClick="submitForm('foo', true, {event:'thresholdsTab'})"
              renderedBinding="showThresholds@defaultBean@servletRequest"/>
            <uix:link textBinding="OCCUPANTS@tablespaceBundle@servletRequest"/>
          </uix:subTabBar>
        </uix:subTabs>

        <uix:header textBinding="SYSAUX_USAGE_HDR@tablespaceBundle@servletRequest" size="1">
          <uix:labeledFieldLayout labelWidth="20%">
            <uix:messagePrompt promptBinding="TOTAL_SPACE_USED_MB@tablespaceBundle@servletRequest"/>
            <uix:styledText styleClass="OraDataText" textBinding="totalOccupantSpaceUsed@defaultBean@servletRequest"/>            
            <uix:messagePrompt promptBinding="FREE_SPACE_MB@tablespaceBundle@servletRequest"/>
            <uix:styledText styleClass="OraDataText" textBinding="tbspFreeSpace@defaultBean@servletRequest"/>            
            
            <uix:messagePrompt promptBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest"/>
            <uix:styledText styleClass="OraDataText" textBinding="spaceUsedPercent@defaultBean@servletRequest"/>            
          </uix:labeledFieldLayout>
          <uix:stackLayout>
          
            <oem:chart
              titleBinding="SYSAUX_USAGE_HDR@tablespaceBundle@servletRequest" 
              titleVisible="false"
              chartType="pieChart"
              width="250"
              height="200"
              hideZeroSlices="true"
              showSlicePercentLabels="true"
              legendVisible="external"
              legendPosition="east"
              pieValuesInLegend="percent"
              yAxisNumberFormatBinding="pieChartLegendFormat@defaultBean@servletRequest"
              >
                <oem:boundChartDataSource
                  chartDataSourceBinding="occupantPieChartDataSource@defaultBean@servletRequest"
                />
                <%-- Consumer Group --%>
                  <oem:chartColumn
                    displayLabel="label1"
                    sourceIndex="0"
                    isKey="true"                    
                  />
                  <%-- Consumed CPU Time --%>
                  <oem:chartColumn
                    displayLabel="label2"
                    sourceIndex="2"
                  />
            </oem:chart>            
          </uix:stackLayout>
        </uix:header>


          <uix:header textBinding="SYSAUX_OCCUPANTS_HDR@tablespaceBundle@servletRequest" size="1">                                                  

            <uix:stackLayout>
            <%--
              <uix:switcher childNameBinding="sysdbaUser@defaultBean@servletRequest">
                <uix:case name="false">
                  <uix:messagePrompt promptBinding="SYSDBA_CAN_CHANGE_TABLESPACE@tablespaceBundle@servletRequest"/>
                </uix:case>
              </uix:switcher>
            --%>
              <oem:table name="occupantsTable"
                         width="80%"
                         formSubmitted="true"
                         dataSourceProp="occupantsTable"
                         summaryBinding="SYSAUX_OCCUPANTS_HDR@tablespaceBundle@servletRequest"
                         beanKey="occupantsUIBean" copyParams="target,type,oname"
                         alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
              </oem:table>
              <uix:spacer height="5"/>
            </uix:stackLayout>
            </uix:header>

          </uix:subTabLayout>      
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />
            </uix:pageButtonBar>
          </uix:pageButtons>
              

        </uix:pageLayout>
      </db:form>
      </uix:body>

     </uix:document>
    </uix:renderingContext>

