<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="TABLESPACE_OFFLINE_TITLE@tablespaceBundle@servletRequest"/>
    </uix:metaContainer>

    <db:form name="foo" method="post" destinationBinding="defaultControllerURL@mainEmoBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/offlineOptions"/>

    <uix:pageLayout renderedBinding="em@servletRequest" titleBinding="TABLESPACE_OFFLINE_HEADER@tablespaceBundle@servletRequest">
       
    <% if (request.getAttribute("em2goApp") != null) {%>
         <%@ include file="/em2go/em2goGlobal.jspf" %>
         <%@ include file="/em2go/em2goFooter.jspf" %>
         
    <% } else {%>   
        <%@ include file="/database/global.jspf" %>
     <%} %>

    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
     
    <uix:stackLayout>
      <uix:rowLayout>
        <uix:messagePrompt promptBinding="OFFLINE_MODES_TEXT@tablespaceBundle@servletRequest"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer width="10"/>
        <uix:stackLayout>
          <uix:radioButton textBinding="OFFLINE_MODE_NORMAL@tablespaceBundle@servletRequest"
                    name="offlineMode"
                    selected="true"
                    value="1"
                    selectedValueBinding="offlineMode@defaultBean@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="15"/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OFFLINE_MODE_NORMAL_HINT@tablespaceBundle@servletRequest"/>
          </uix:rowLayout>

          <uix:radioButton textBinding="OFFLINE_MODE_TEMPORARY@tablespaceBundle@servletRequest"
                    name="offlineMode"
                    value="2"
                    selectedValueBinding="offlineMode@defaultBean@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="15"/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OFFLINE_MODE_TEMPORARY_HINT@tablespaceBundle@servletRequest"/>
          </uix:rowLayout>

          <uix:radioButton textBinding="OFFLINE_MODE_IMMEDIATE@tablespaceBundle@servletRequest"
                    name="offlineMode"
                    value="3"
                    selectedValueBinding="offlineMode@defaultBean@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="15"/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OFFLINE_MODE_IMMEDIATE_HINT@tablespaceBundle@servletRequest"/>
          </uix:rowLayout>

          <uix:radioButton textBinding="OFFLINE_MODE_RECOVER@tablespaceBundle@servletRequest"
                    name="offlineMode"
                    value="4"
                    selectedValueBinding="offlineMode@defaultBean@servletRequest"/>
          <uix:rowLayout>
            <uix:spacer width="15"/>
            <uix:styledText styleClass="OraInlineInfoText" textBinding="OFFLINE_MODE_RECOVER_HINT@tablespaceBundle@servletRequest"/>
          </uix:rowLayout>

        </uix:stackLayout>
      </uix:rowLayout>
    </uix:stackLayout>

      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:submitButton name="event" value="cancel"
                  textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                  formName="foo"/>
          <uix:submitButton name="event" value="offlineEvent"
                  textBinding="OK@uixDBObjectBundle@servletRequest" formName="foo"/>

        </uix:pageButtonBar>
      </uix:pageButtons>
     </uix:pageLayout>
  </db:form>

</uix:document>
</uix:renderingContext>


