<%--
  -- Page:        showSegmentExtents.jsp
  -- Controller:  oracle.sysman.db.adm.stg.TablespaceController
  --
  -- Description: Launched when user clicks on an extent link in the Extents column 
  --              of the Segments table on the Show Tablespace Contents page
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  10/21/04 - add PPR, use UIXDataSource constants
  --     mpawelko  09/22/04 - add Show All capability 
  --     mpawelko  09/20/04 - add GUI review changes 
  --     mpawelko  08/26/04 - change blockSize to 25 
  --     mpawelko  08/03/04 - mpawelko_tsmap_extents_per_segment
  --     mpawelko  03/30/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.storage.tablespace.ShowSegmentsConstants" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="TSMsgs"
              class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %> 

    <%-- Body tag wil indent page from edge of window --%>
    <uix:body>

      <uix:dataScope currentDataBinding="segmentExtentsBean@servletRequest"> 

        <%-- HTML Form --%>
        <db:form name="tsExtents" 
                 method="post" 
                 destinationBinding="<%= ShowSegmentsConstants.S_PAGE_DESTINATION %>"
                 copyParams="target,type,cancelURL,oname,otype" >
          <uix:formValue name="pageName" value="/database/storage/tablespace/showSegmentExtents"/>
          <uix:pageLayout titleBinding="<%= ShowSegmentsConstants.S_PAGE_HEADER %>">
            <%-- Oracle Logo and Tabs --%>
             <%@ include file="/database/global.jspf" %>

            <%-- Warning/Error display --%>
              <oem:messageBox messageType="error" 
                              errorTableBinding="errors@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>
              <oem:messageBox messageType="info" 
                              errorTableBinding="info@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>

              <uix:table id="extentsList" 
                         alternateTextBinding="NO_EXTENTS_FOUND@TSMsgs"
                         formSubmitted="true"
                         width="80%"
                         tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                         minValue="1"
                         valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                         maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                         showAll="yes"
		         partialRenderMode="self"
                         blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                         summaryBinding="SHOW_EXTENTS_DESC@TSMsgs">
               
                <uix:tableFormat tableBanding="rowBanding"/>

                <%-- Extent ID column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="EXTENT_ID@TSMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_EXTENT_ID_COL %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_EXTENT_ID_COL %>"/>
                </uix:column>

                <%-- Block ID column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="BLOCK_ID@TSMsgs"  sortableBinding="<%= ShowSegmentsConstants.S_SORT_BLOCK_ID_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_BLOCK_ID_COL %>"/>
                </uix:column>

                <%-- Size (blocks) column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="SIZE_BLOCKS@TSMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_EXTSIZE_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_EXTSIZE_COL %>"/>
                </uix:column>

                <%-- Datafile column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="DATAFILE@TSMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_DATAFILE_COL %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_DATAFILE_COL %>" />
                </uix:column>
                  
              </uix:table>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="RETURN@DBObjectMsgs"
                                  name="event"
                                  value="cancelShowExt" /> 
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>

        </db:form>
        <%-- END: HTML Form --%>

      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Page Content --%> 

