<%--
  -- Page:        showSegments.jsp
  -- Controller:  oracle.sysman.db.adm.stg.TablespaceController
  --
  -- Description: Launched when user selects "Show Tablespace Contents" tablespace action
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  05/13/05 - fix oac violations 
  --     mpawelko  10/21/04 - use UIXDataSource constants 
  --     chanchan  10/19/04 - Add licensing 
  --     mpawelko  09/24/04 - Move extent count and tip above segment table 
  --     mpawelko  09/22/04 - add related links; move legend from top to right
  --     mpawelko  09/21/04 - show Block Size only if 9i+; more GUI review changes 
  --     mpawelko  09/20/04 - add GUI review changes 
  --     mpawelko  09/11/04 - change header color from gray to magenta 
  --     mpawelko  08/24/04 - remove borderWidth from highlight extents images 
  --     mpawelko  08/11/04 - use special event for Return to free memory asap 
  --     mpawelko  08/03/04 - make extents column a link 
  --     mpawelko  07/28/04 - reduce cell spacing in search
  --     mpawelko  07/23/04 - add unmapped icon 
  --     mpawelko  07/09/04 - add search filters 
  --     mpawelko  06/25/04 - fix clear_box gif 
  --     mpawelko  06/01/04 - add interaction between segments and extents 
  --     mpawelko  05/30/04 - add tablespace map graph 
  --     mpawelko  05/20/04 - add tablespace summary fields 
  --     mpawelko  03/31/04 - mpawelko_add_ts_show_segments 
  --     mpawelko  03/30/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<script language="javascript">
<%-- sa stands for setAction, needs to be short because it's included per map node --%>
function sa()
{
  document.tsSegments.action += "#extMap";
}
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.storage.tablespace.ShowSegmentsConstants" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %> 

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBMsgs"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="DBObjectMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="TSMsgs"
              class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %> 

    <%-- Body tag wil indent page from edge of window --%>
    <uix:body>

      <uix:dataScope currentDataBinding="showSegmentsBean@servletRequest"> 

        <%-- HTML Form --%>
        <db:form name="tsSegments" 
                 method="post" 
                 destinationBinding="<%= ShowSegmentsConstants.S_PAGE_DESTINATION %>"
                 copyParams="target,type,cancelURL,oname,otype" >
          <uix:formValue name="pageName" value="/database/storage/tablespace/showSegments"/>
          <uix:pageLayout titleBinding="<%= ShowSegmentsConstants.S_PAGE_HEADER %>">
            <%-- Oracle Logo and Tabs --%>
             <%@ include file="/database/global.jspf" %>

            <uix:pageStatus>  
            <uix:labeledFieldLayout columns="4">
              <%-- Size (MB) --%>
              <uix:messagePrompt promptBinding="SIZE_M@DBObjectMsgs"/>	
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_SIZE_MB %>"/>

              <%-- Used (MB) --%>
              <uix:messagePrompt promptBinding="USED_SIZE_M@DBObjectMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_USED_MB %>"/>

              <%-- Extent Mgmt --%>
              <uix:messagePrompt promptBinding="TS_EXT_MGMT@TSMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_EXT_MGMT %>"/>

              <%-- Auto Extend --%>
              <uix:messagePrompt promptBinding="AUTO_EXTEND@DBObjectMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_AUTO_EXT %>"/>

              <%-- Block Size (KB) --%>
              <uix:messagePrompt promptBinding="BLOCKSIZE_KB@TSMsgs"
                                 renderedBinding="<%= ShowSegmentsConstants.S_DB_9i_OR_HIGHER %>"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_BLOCKSIZE_KB %>"
                                 renderedBinding="<%= ShowSegmentsConstants.S_DB_9i_OR_HIGHER %>"/>

              <%-- Used (%) --%>
              <uix:messagePrompt promptBinding="USED_PERCENT@DBObjectMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_USED_PCT %>"/>

              <%-- Segment Mgmt --%>
              <uix:messagePrompt promptBinding="TS_SEG_MGMT@TSMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_SEG_MGMT %>"/>

              <%-- Total Extents --%>
              <uix:messagePrompt promptBinding="EXTENTS@DBObjectMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="<%= ShowSegmentsConstants.S_TOTAL_EXT %>"/>

            </uix:labeledFieldLayout>
            </uix:pageStatus>  

            <%-- Warning/Error display --%>
            <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:header textBinding="TS_SEGMENTS@TSMsgs">

              <%-- Total Extents --%>
              <uix:stackLayout renderedBinding="<%= ShowSegmentsConstants.S_PARTIAL_MAP %>">
                <uix:messageStyledText styleClass="OraDataText" promptBinding="TS_CURR_EXT@TSMsgs" 
                                       textBinding="<%= ShowSegmentsConstants.S_CURR_EXT %>" />
                <uix:spacer height="10"/>
                <uix:rowLayout width="100%">
                  <uix:tip textBinding="<%= ShowSegmentsConstants.S_CURR_EXT_TIP %>" />
                </uix:rowLayout>                     
              </uix:stackLayout>

              <uix:header textBinding="SEARCH@DBObjectMsgs">

                <uix:tableLayout cellSpacing="0" width="80%"> 
                  <uix:rowLayout width="80%" vAlign="top">
                
                   <%-- Search Segment Name --%>
                   <uix:stackLayout>
                     <uix:styledText labeledNodeId="segmentNode" 
                                     styleClass="OraPromptText" 
                                     textBinding="TBLDET_SEGMENT_NAME@DBMsgs" />
                     <uix:textInput id="segmentNode" 
                                    name="<%= ShowSegmentsConstants.S_NAME_FILTER %>"
                                    columns="40"
		                    textBinding="<%= ShowSegmentsConstants.S_NAME_FILTER %>" />
                     <uix:styledText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@DBObjectMsgs" />
                   </uix:stackLayout>

                   <%-- Search Segment Type --%>
                   <uix:stackLayout>
                     <uix:styledText labeledNodeId="typeNode" 
                                     styleClass="OraPromptText" 
                                     textBinding="TBLDET_SEGMENT_TYPE@DBMsgs"/>
                     <uix:choice id="typeNode" 
                                 name="<%= ShowSegmentsConstants.S_TYPE_FILTER %>"
                                 selectedValueBinding="<%= ShowSegmentsConstants.S_TYPE_FILTER %>" 
                                 shortDescBinding="TBLDET_SEGMENT_TYPE@DBMsgs" >
                       <uix:contents childDataBinding="<%= ShowSegmentsConstants.S_TYPE_FILTER_OPTIONS %>" >
                         <uix:option textBinding="text" valueBinding="value" />
                       </uix:contents>
                     </uix:choice>
                   </uix:stackLayout>

                   <%-- Search Segment Size --%>
                   <uix:stackLayout>
                     <uix:styledText labeledNodeId="sizeNode" 
                                     styleClass="OraPromptText" 
                                     textBinding="TS_MIN_SIZE_TIP@TSMsgs" />
                     <uix:messageTextInput id="sizeNode" 
                                           name="<%= ShowSegmentsConstants.S_SIZE_FILTER %>"
                                           columns="14"
		                           textBinding="<%= ShowSegmentsConstants.S_SIZE_FILTER %>" >
                       <uix:onSubmitValidater>
                         <uix:regExp pattern="[0-9]*$"/>
                       </uix:onSubmitValidater>
                     </uix:messageTextInput>
                   </uix:stackLayout>

                   <%-- Search Extent Size --%>
                   <uix:stackLayout>
                     <uix:styledText labeledNodeId="extentNode" 
                                     styleClass="OraPromptText" 
                                     textBinding="TS_MIN_EXTENTS_TIP@TSMsgs" />
                     <uix:rowLayout vAlign="top">
                       <uix:messageTextInput id="extentNode" 
                                             name="<%= ShowSegmentsConstants.S_EXTENTS_FILTER %>"
                                             columns="10"
                       		       textBinding="<%= ShowSegmentsConstants.S_EXTENTS_FILTER %>" >
                         <uix:onSubmitValidater>
                           <uix:regExp pattern="[0-9]*$"/>
                         </uix:onSubmitValidater>
                       </uix:messageTextInput>

                       <uix:spacer width="5"/>
                       <uix:submitButton textBinding="GO@DBObjectMsgs"
                                         name="event"
                             	         value="searchSegments" />
                     </uix:rowLayout>
                   </uix:stackLayout>
                 </uix:rowLayout>
               </uix:tableLayout>

               <uix:separator/>

              <uix:table id="segmentsList" 
                         alternateTextBinding="NO_SEGMENTS_FOUND@TSMsgs"
                         formSubmitted="true"
                         width="80%"
                         tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                         minValue="1"
                         valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                         maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                         blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                         showAll="yes" 
                         partialRenderModeBinding="<%= ShowSegmentsConstants.S_RENDER_MODE_ATTR %>"
                         summaryBinding="SHOW_SEGMENTS_DESC@TSMsgs" >
               
                <uix:tableFormat tableBanding="rowBanding"/>

               <%-- Highlight Extents column --%>
                <uix:column renderedBinding="<%= ShowSegmentsConstants.S_SHOW_HLEXT_COL %>">
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="HL_EXTENTS@TSMsgs" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                  <uix:image sourceBinding="<%= ShowSegmentsConstants.S_HL_IMAGE %>" 
                             onClickBinding="<%= ShowSegmentsConstants.S_HL_CLICK %>" />
                </uix:column>
<%--
                    <uix:image source="/em/images/database/storage/clear_box.gif"  borderWidth="1" onClick="submitForm('tsSegments', true, {event:'highlightExtents'})" />

                    <uix:checkBox onClick="submitForm('tsSegments', true, {event:'highlightExtents'})" />

                    <uix:radioButton name="select" onClick="submitForm('tsSegments', true, {event:'highlightExtents'})" />
--%>

                <%-- Name column --%>
                <uix:column> 
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TBLDET_SEGMENT_NAME@DBMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_NAME_COL %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_NAME_COL %>"/>
                </uix:column>

                <%-- Type column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TBLDET_SEGMENT_TYPE@DBMsgs"  sortableBinding="<%= ShowSegmentsConstants.S_SORT_TYPE_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_TYPE_COL %>"/>
                </uix:column>

                <%-- Size column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="SIZE_K@DBObjectMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_SIZE_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_SIZE_COL %>"/>
                </uix:column>

                <%-- Extents column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TBLDET_EXTENT@DBMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_EXTENTS_COL %>" />
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:link textBinding="<%= ShowSegmentsConstants.S_EXTENTS_COL %>"
                            onClickBinding="<%= ShowSegmentsConstants.S_EXT_CLICK %>" />
                </uix:column>
                  
                <%-- max_extents column --%>
                <uix:column renderedBinding="<%= ShowSegmentsConstants.S_SHOW_MAXEXT_COL %>">
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TBLDET_MAX_EXTENT@DBMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_MAXEXT_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= ShowSegmentsConstants.S_MAXEXT_COL %>"/>
                </uix:column>

                <%-- next_extent column --%>
                <uix:column renderedBinding="<%= ShowSegmentsConstants.S_SHOW_NEXTEXT_COL %>">
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TBLDET_NEXT_MB@DBMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_NEXTEXT_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                  <uix:styledText textBinding="<%= ShowSegmentsConstants.S_NEXTEXT_COL %>"/>
                </uix:column>

                <%-- pct_increase column --%>
                <uix:column renderedBinding="<%= ShowSegmentsConstants.S_SHOW_PCTINCR_COL %>">
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="INCREMENT_SIZE@DBObjectMsgs" sortableBinding="<%= ShowSegmentsConstants.S_SORT_PCTINCR_COL %>"/>
                  </uix:columnHeader> 
                  <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= ShowSegmentsConstants.S_PCTINCR_COL %>"/>
                </uix:column>
              </uix:table>
          </uix:header>
        </uix:header>

    <uix:switcher childNameBinding="licenseExtentMap@servletRequest">
      <uix:case name="true">
        <uix:hideShowHeader id="extentMapHideShow"
                            textBinding="TS_SHOW_MAP@TSMsgs"
                            disclosedBinding="<%= ShowSegmentsConstants.S_SHOW_EXTENT_MAP %>"
                            formName="tsSegments"
                            formSubmitted="true" >

          <uix:stackLayout>
            <uix:styledText textBinding="TSMAP_INTERACTION@TSMsgs"
                            styleClass="OraInstructionText" /> 
          </uix:stackLayout>

          <%-- Include Tablespace Map topology graph  --%>

          <%-- Add an anchor so map renders at top after handling map events --%>
          <%-- NOTE: Don't move this anchor, because it gets ignored in --%> 
          <%-- some locations (UIX bug?) --%>
          <uix:rawText>
            <a name="extMap"/>
          </uix:rawText>

          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat vAlign="top" hAlign="left" width="80%">
                <%-- Tablespace Map graph image --%>
                <uix:rawText textBinding="graphURL@showSegmentsBean@servletRequest"/>
              </uix:cellFormat>

              <uix:cellFormat vAlign="top"  hAlign="left" width="20%">
                <uix:labeledFieldLayout width="50%" labelWidth="25%">
                  <uix:messagePrompt prompt=""/>
                  <uix:messagePrompt prompt=""/>
                  <uix:image sourceBinding="<%= ShowSegmentsConstants.S_MAGENTA_BOX_IMAGE %>" borderWidth="1"/>
                  <uix:messagePrompt promptBinding="HEADER@TSMsgs"/>
                  <uix:image sourceBinding="<%= ShowSegmentsConstants.S_CYAN_BOX_IMAGE %>" borderWidth="1"/>
                  <uix:messagePrompt promptBinding="USED@TSMsgs"/>
                  <uix:image sourceBinding="<%= ShowSegmentsConstants.S_GREEN_BOX_IMAGE %>" borderWidth="1"/>
                  <uix:messagePrompt promptBinding="FREE@TSMsgs"/>
                  <uix:image sourceBinding="<%= ShowSegmentsConstants.S_YELLOW_BOX_IMAGE %>" borderWidth="1"/>
                  <uix:messagePrompt promptBinding="SELECTED@TSMsgs"/>
                  <uix:image sourceBinding="<%= ShowSegmentsConstants.S_BLACK_BOX_IMAGE %>" borderWidth="1"/>
                  <uix:messagePrompt promptBinding="UNMAPPED@TSMsgs"/>
                  <uix:messagePrompt prompt=""/>
                  <uix:messagePrompt prompt=""/>

                  <uix:messagePrompt promptBinding="TS_ZOOM@TSMsgs"
                                     labeledNodeId="zoomLevel"/>
                  <uix:choice name="zoomLevel" 
                              id="zoomLevel"
                              shortDescBinding="TS_ZOOM@TSMsgs"
                              selectedValueBinding="<%= ShowSegmentsConstants.S_ZOOM_LEVEL %>"
                              onChange="sa();submitForm('tsSegments',true,{'event':'zoomMap'})" >

                    <uix:option textBinding="TS_25_PCT@TSMsgs" value="1" />
                    <uix:option textBinding="TS_50_PCT@TSMsgs" value="2" />
                    <uix:option textBinding="TS_75_PCT@TSMsgs" value="3" />
                    <uix:option textBinding="TS_100_PCT@TSMsgs" value="4" />
                    <uix:option textBinding="TS_150_PCT@TSMsgs" value="6" />
                    <uix:option textBinding="TS_200_PCT@TSMsgs" value="8" />
                    <uix:option textBinding="TS_250_PCT@TSMsgs" value="10" />
                    <uix:option textBinding="TS_300_PCT@TSMsgs" value="12" />
                  </uix:choice>  
                </uix:labeledFieldLayout> 
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

        </uix:hideShowHeader>
      </uix:case>
    </uix:switcher>
   
         <%-- Reorganize and Segment Advisor/Segment Findings Related Links  --%>
         <oem:relatedLinks />

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="RETURN@DBObjectMsgs"
                                  name="event"
                                  unvalidated="true"
                                  value="cancelShowContents" /> 
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>

        </db:form>
        <%-- END: HTML Form --%>

      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Page Content --%> 

