<%--
  -- Page:        showSegmentsProcess.jsp
  -- Controller:  oracle.sysman.db.adm.stg.TablespaceController
  --
  -- Description: Process (in progress) page displayed during retrieval of segments for Show Tablespace Contents 
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  05/13/05 - fix oac violations 
  --     mpawelko  10/21/04 - remove hardcoded context path from image name 
  --     mpawelko  09/20/04 - add GUI review changes 
  --     mpawelko  09/18/04 - change cancelShowContents event to cancelShowSeg 
  --     kmckeen   09/01/04 - Remove percentComplete attr from uix:processing 
  --                          tag 
  --     mpawelko  07/13/04 - add pageName to copyParams 
  --     mpawelko  06/29/04 - mpawelko_fix_tablespacemap
  --     mpawelko  06/28/04 - created 
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="DBObjectMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="TSMsgs"
              class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>
<oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%-- <%@ include file="/enablePPR.jspf" %> --%>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <db:form name="processForm" 
               method="post" 
               destinationBinding="pageDestination@servletRequest"
               copyParams="target,type,pageName,cancelURL,oname,otype,processId2" >
          <uix:formValue name="pageName" value="/database/storage/tablespace/showSegmentsProcess"/>

        <uix:pageLayout>
	  <%@ include file="/database/globalPopup.jspf" %>

          <uix:header textBinding="TS_SHOW_CONTENTS_PROC@TSMsgs"
                      iconBinding="processImage@servletRequest" >
            <uix:stackLayout>
              <uix:spacer height="5" />
              <uix:styledText styleClass="OraDataText" 
                              textBinding="PROCESS_SEGMENTS_INFO@TSMsgs"/>
              <uix:spacer height="5" />
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="PROCESS_SEGMENTS_INFO2@TSMsgs"/>
              <uix:spacer height="20"/> 

              <uix:processing timeInterval="<%=processingPageInterval%>">
                <uix:styledText styleClass="OraProcessingStatusFixed"
                                textBinding="PROCESS_SEGMENTS@TSMsgs"/>
              </uix:processing>
            </uix:stackLayout>
          </uix:header>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@DBObjectMsgs" 
                                name="event" 
                                value="cancelShowSeg" /> 
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>


