<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Page:       storagePage.jsp
  -- Controller: db/adm/stg/TablespaceController.java
  --
  -- Description: The Storage tab for Table.  
  --              This tab allows the user to see/edit 
  --              their table's storage parameters.
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    07/09/09 - Support new compression GUI (ER bug 8669360)
  --   chanchan    05/08/09 - Add columnar compression supports (ER bug #8276145)
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="tbsStorage" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tablespace/storagePage"/>

    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">

    <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <uix:subTabLayout>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="1">
          <uix:contents>
          <uix:link textBinding="GENERAL@tablespaceBundle@servletRequest"
                    onClick="submitForm('tbsStorage', true, {event:'generalTab'})"/>
          <uix:link textBinding="STORAGE@tablespaceBundle@servletRequest"/>
          <uix:link textBinding="THRESHOLDS@tablespaceBundle@servletRequest"
                    onClick="submitForm('tbsStorage', true, {event:'thresholdsTab'})"
                    renderedBinding="showThresholds@mainEmoBean@servletRequest"/>
          <uix:link textBinding="OCCUPANTS@tablespaceBundle@servletRequest"
                    onClick="submitForm('tbsStorage', true, {event:'occupantsTab'})"
                    renderedBinding="sysauxTablespace@tsStorageBean@servletRequest"
                    disabledBinding="sysauxOffline@tsStorageBean@servletRequest"/>
        </uix:contents>
        </uix:subTabBar>
      </uix:subTabs>


      <uix:switcher childNameBinding="81OrHigher@mainEmoBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="local@extentMgmtBean@servletRequest">
            <uix:case name="true">
              <jsp:include page="/database/storage/tablespace/localStoragePage.jsp" />
              <uix:ref refID="localStoragePage" />
            </uix:case>
            <uix:case name="false">
              <jsp:include page="/database/storage/tablespace/dictionaryStoragePage.jsp" />
              <uix:ref refID="dictionaryStoragePage" />
            </uix:case>
          </uix:switcher>
        </uix:case>
        <uix:case name="false">   <%--Pre 81 Databases will default to the dictionary page--%>
                     <jsp:include page="/database/storage/tablespace/dictionaryStoragePage.jsp" />
          <uix:ref refID="dictionaryStoragePage" />
        </uix:case>
      </uix:switcher>

      <%-- bug 4294500, have to show extent info for converted locally managed tbsp --%>
      <uix:switcher childNameBinding="81OrHigher@mainEmoBean@servletRequest">
        <uix:case name="true">
          <uix:switcher childNameBinding="convertedLocalMgmtTbsp@extentMgmtBean@servletRequest">
            <uix:case name="true">
              <jsp:include page="/database/storage/tablespace/dictionaryStoragePage.jsp" />
              <uix:ref refID="dictionaryStoragePage" />
            </uix:case>
          </uix:switcher>
        </uix:case>
      </uix:switcher>
      
      <uix:switcher childNameBinding="90OrHigher@mainEmoBean@servletRequest">
        <uix:case name="true">
      	  <uix:switcher childNameBinding="undo@mainEmoBean@servletRequest">
            <uix:case name="false">
      	      <uix:dataScope currentDataBinding="tsStorageBean@servletRequest">
     	        <%-- START: Compress Options starts here --%>
	        <jsp:include page="/database/schema/compressOptionsInclude.jsp" />
	        <uix:ref refID="compressInclude" />
	        <%-- END: Compress Options ends here --%>
	      </uix:dataScope>
            </uix:case>
      	  </uix:switcher>
        </uix:case>
      </uix:switcher>

      <uix:switcher childNameBinding="undo@mainEmoBean@servletRequest">
        <uix:case name="false">
          <uix:switcher  childNameBinding="localAndTemp@mainEmoBean@servletRequest">
            <uix:case name="false">
              <uix:header textBinding="ENABLE_LOGGING@tablespaceBundle@servletRequest"
                          size="1">
                <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
	              <oem:radioButton name="logging"
                                 value="true"
                                 textBinding="YES@uixDBObjectBundle@servletRequest"
                                 
                                 selectedValueBinding="logging@tsStorageBean@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <uix:spacer width="15"/>
                    <uix:styledText styleClass="OraInlineInfoText" textBinding="ENABLE_LOGGING_YES_HINT@tablespaceBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
	              <oem:radioButton name="logging"
                                 value="false"
                                 textBinding="NO@uixDBObjectBundle@servletRequest"
                                 selectedValueBinding="logging@tsStorageBean@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <uix:spacer width="15"/>
                    <uix:styledText styleClass="OraInlineInfoText" textBinding="ENABLE_LOGGING_NO_HINT@tablespaceBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
     </uix:header>
            </uix:case>
          </uix:switcher>
        </uix:case>
      </uix:switcher>

      <uix:switcher childNameBinding="82OrHigher@mainEmoBean@servletRequest">
        <uix:case name="true">
          <uix:header textBinding="BLOCK_INFORMATION@tablespaceBundle@servletRequest" size="1">
          <uix:tableLayout  cellSpacing="5">
            <uix:rowLayout>
              <uix:messagePrompt promptBinding="BLOCK_SIZE_WITH_BYTES@tablespaceBundle@servletRequest"/>
              <uix:flowLayout>
                <uix:switcher childNameBinding="creating@mainEmoBean@servletRequest">
                  <uix:case name="true">
                    <uix:switcher childNameBinding="additionalBlockSizes@tsStorageBean@servletRequest">
                      <uix:case name="true">
                        <oem:choice name="blockSize"
                                    id="blockSize"
                                    optionsBinding="blockSizeChoices@tsStorageBean@servletRequest"
                                    selectedValueBinding="blockSize@tsStorageBean@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="blockSize@tsStorageBean@servletRequest"/>
                      </uix:case>      
                    </uix:switcher>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="blockSize@tsStorageBean@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:flowLayout>
            </uix:rowLayout>

          </uix:tableLayout>
          </uix:header>
        </uix:case>
      </uix:switcher>


    </uix:subTabLayout>

    <uix:pageButtons>
      <uix:pageButtonBar>
        <jsp:include page="/database/schema/pageButtonInclude.jsp" />
        <uix:ref refID="pageButtonInclude" />
      </uix:pageButtonBar>
    </uix:pageButtons>


  </uix:pageLayout>
</db:form>
</uix:body>

</uix:document>
</uix:renderingContext>

