<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

  <uix:metaContainer>
    <!-- Need to get this from the bean to add Oracle Enterprise Manager prefix -->
    <uix:head titleBinding="modifyDefaultThresholdsTitle@thresholdsBean@servletRequest"/>
  </uix:metaContainer>

  <uix:body>
  <db:form name="tbsDefaultThresholds" method="post" 
           destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
           copyParams="target,type,cancelURL,oname,otype">

    <uix:formValue name="pageName" value="/database/storage/tablespace/thresholdsDefaultsPage"/>

    <uix:pageLayout titleBinding="modifyDefaultThresholdsHeader@thresholdsBean@servletRequest">

      <%-- for breadcrumbs support; plus standard label, links, tabs, etc --%>
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
           errorTableBinding="info@servletRequest"
           titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
           errorTableBinding="errors@servletRequest"
           titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:pageStatus>
        <uix:styledText styleClass="OraInstructionText"
             textBinding="CHANGE_DEFAULTS_TIP@tablespaceBundle@servletRequest"/>
      </uix:pageStatus>

      <%-- Database Default Metric Thresholds Layout: START --%>

      <%-- Space Used: Default Metric Thresholds --%>
      <uix:header textBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest"
                  renderedBinding="modifyDbSpaceUsed@thresholdsBean@servletRequest">
      <uix:stackLayout>

          <%-- Space Used: Info Text --%>
          <uix:styledText styleClass="OraPromptText"
               textBinding="SPACE_USED_INFO@tablespaceBundle@servletRequest"/>
          <uix:spacer height="5"/>

          <uix:tableLayout>

          <%-- Space Used: Specify Thresholds --%>
          <uix:rowLayout>
            <uix:radioButton
                 name="dbSpaceUsedTbspcOption"
                 textBinding="SPECIFY_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                 selectedValueBinding="dbSpaceUsedTbspcOption@thresholdsBean@servletRequest"
                 valueBinding="THRESHOLDS_OPT_USE_SPECIFIED@thresholdsBean@servletRequest"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:labeledFieldLayout>
              <uix:messageTextInput 
                   name="dbSpaceUsedWarning"
                   id="dbSpaceUsedWarning"
                   promptBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                   shortDescBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                   columns="5"
                   textBinding="dbSpaceUsedWarning@thresholdsBean@servletRequest">
                 <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
               </uix:messageTextInput>
               <uix:messageTextInput 
                    name="dbSpaceUsedCritical"
                    id="dbSpaceUsedCritical"
                    promptBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                    shortDescBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                    columns="5"
                    textBinding="dbSpaceUsedCritical@thresholdsBean@servletRequest">
                 <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
               </uix:messageTextInput> 
            </uix:labeledFieldLayout>
          </uix:rowLayout>

          <%-- Space Used: Disable Thresholds --%>
          <uix:rowLayout>
            <uix:radioButton
                 name="dbSpaceUsedTbspcOption"
                 textBinding="DISABLE_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                 selectedValueBinding="dbSpaceUsedTbspcOption@thresholdsBean@servletRequest"
                 valueBinding="THRESHOLDS_OPT_DISABLE@thresholdsBean@servletRequest"/>
          </uix:rowLayout>

          </uix:tableLayout>

      </uix:stackLayout>
      </uix:header>



      <%-- Free Space: Default Metric Thresholds --%>
      <uix:header textBinding="FREE_SPACE_MB@tablespaceBundle@servletRequest"
                  renderedBinding="modifyDbFreeSpace@thresholdsBean@servletRequest">
      <uix:stackLayout>

          <%-- Free Space: Info Text --%>
          <uix:styledText styleClass="OraPromptText"
               textBinding="FREE_SPACE_INFO@tablespaceBundle@servletRequest"/>
          <uix:spacer height="5"/>

          <uix:tableLayout>

          <%-- Free Space: Specify Thresholds --%>
          <uix:rowLayout>
            <uix:radioButton
                 name="dbFreeSpaceTbspcOption"
                 textBinding="SPECIFY_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                 selectedValueBinding="dbFreeSpaceTbspcOption@thresholdsBean@servletRequest"
                 valueBinding="THRESHOLDS_OPT_USE_SPECIFIED@thresholdsBean@servletRequest"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:labeledFieldLayout>
              <uix:messageTextInput 
                   name="dbFreeSpaceWarning"
                   id="dbFreeSpaceWarning"
                   promptBinding="WARNING_MB@tablespaceBundle@servletRequest"
                   shortDescBinding="WARNING_MB@tablespaceBundle@servletRequest"
                   columns="10"
                   textBinding="dbFreeSpaceWarning@thresholdsBean@servletRequest">
                 <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
               </uix:messageTextInput>
               <uix:messageTextInput 
                    name="dbFreeSpaceCritical"
                    id="dbFreeSpaceCritical"
                    promptBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                    shortDescBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                    columns="10"
                    textBinding="dbFreeSpaceCritical@thresholdsBean@servletRequest">
                 <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
               </uix:messageTextInput> 
            </uix:labeledFieldLayout>
          </uix:rowLayout>

          <%-- Free Space: Disable Thresholds --%>
          <uix:rowLayout>
            <uix:radioButton
                 name="dbFreeSpaceTbspcOption"
                 textBinding="DISABLE_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                 selectedValueBinding="dbFreeSpaceTbspcOption@thresholdsBean@servletRequest"
                 valueBinding="THRESHOLDS_OPT_DISABLE@thresholdsBean@servletRequest"/>
          </uix:rowLayout>

          </uix:tableLayout>

      </uix:stackLayout>
      </uix:header>


      <%-- Database Default Metric Thresholds Layout: END   --%>

      <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest"
             name="event"
             value="defaultThresholdsCancel"
             formName="tbsDefaultThresholds"/>
        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
             name="event"
             value="defaultThresholdsOK"
             formName="tbsDefaultThresholds"/>
      </uix:pageButtonBar>
      </uix:pageButtons>

    </uix:pageLayout>
  
  </db:form>
  </uix:body>

  </uix:document>
</uix:renderingContext>


