<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

        <db:form name="tbsThresholds" method="post" 
             destinationBinding="defaultControllerURL@mainEmoBean@servletRequest"
             copyParams="target,type,cancelURL,oname,otype">
          <uix:formValue name="pageName" value="/database/storage/tablespace/thresholdsPage"/>

          <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">

            <%@ include file="/database/global.jspf" %>

            <oem:messageBox messageType="info"
                errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error"
                errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndex="2">
                      <uix:link textBinding="GENERAL@tablespaceBundle@servletRequest"
                            onClick="submitForm('tbsThresholds', true, {event:'generalTab'})"/>
                      <uix:link textBinding="STORAGE@tablespaceBundle@servletRequest"
                            onClick="submitForm('tbsThresholds', true, {event:'storageTab'})"/>
                      <uix:link textBinding="THRESHOLDS@tablespaceBundle@servletRequest"/>
                      <uix:link textBinding="OCCUPANTS@tablespaceBundle@servletRequest"
                            onClick="submitForm('tbsThresholds', true, {event:'occupantsTab'})"
                            renderedBinding="sysauxTablespace@defaultBean@servletRequest"
                            disabledBinding="sysauxOffline@defaultBean@servletRequest"/>
                  </uix:subTabBar>
                </uix:subTabs>

                  <uix:switcher childNameBinding="thresholdsPageOption@thresholdsBean@servletRequest">
                    <uix:case name="ok">
                      <uix:stackLayout>
                          <uix:spacer height="20"/>
                          <uix:switcher childNameBinding="displayDetailsLink@thresholdsBean@servletRequest">
                            <uix:case name="true">
                              <uix:labeledFieldLayout width="80%" 
                                                      columns="2"
                                                      labelWidth="25%"
                                                      fieldWidth="25%">

                                  <uix:messagePrompt
                                      promptBinding="AVAIL_SPACE_MB@tablespaceBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText"
                                      textBinding="tablespaceSize@thresholdsBean@servletRequest"/>

                                  <uix:messagePrompt
                                      promptBinding="SPACE_USED_MB@tablespaceBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText"
                                      textBinding="tablespaceUsed@thresholdsBean@servletRequest"/>

                                  <uix:messagePrompt
                                      promptBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest"/>
                                  <uix:link
                                      textBinding="tablespacePerc@thresholdsBean@servletRequest"
                            onClick="submitForm('tbsThresholds', true, {event:'showSpaceUsed'})" />

                                  <uix:messagePrompt
                                      renderedBinding="freeSpaceMetricAvail@thresholdsBean@servletRequest"
                                      promptBinding="AVAIL_FREE_SPACE_MB@tablespaceBundle@servletRequest"/>
                                  <uix:link
                                      textBinding="tablespaceFree@thresholdsBean@servletRequest"
                                      renderedBinding="freeSpaceMetricAvail@thresholdsBean@servletRequest"
                            onClick="submitForm('tbsThresholds', true, {event:'showFreeSpace'})" />

                              </uix:labeledFieldLayout>
                            </uix:case>
                            <uix:case name="false">
                              <uix:labeledFieldLayout width="80%" 
                                                      columns="2"
                                                      labelWidth="25%"
                                                      fieldWidth="25%">

                                  <uix:messagePrompt
                                      promptBinding="TBSPC_SIZE@tablespaceBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText"
                                      textBinding="tablespaceSize@thresholdsBean@servletRequest"/>

                                  <uix:messagePrompt
                                      promptBinding="FREE_SPACE_MB@tablespaceBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText"
                                      textBinding="tablespaceFree@thresholdsBean@servletRequest"/>

                                  <uix:messagePrompt
                                      promptBinding="SPACE_USED_MB@tablespaceBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText"
                                      textBinding="tablespaceUsed@thresholdsBean@servletRequest"/>

                                  <uix:messagePrompt
                                      promptBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest"/>
                                  <uix:styledText styleClass="OraDataText"
                                      textBinding="tablespacePerc@thresholdsBean@servletRequest"/>

                              </uix:labeledFieldLayout>
                            </uix:case>
                          </uix:switcher>

                          <uix:spacer height="10"/>

                          <%-- Threshold Options : START --%>
                          <uix:header textBinding="THRESHOLD_OPTION@tablespaceBundle@servletRequest">
                          <uix:stackLayout>

                            <%-- Threshold Info Text --%>
                            <uix:styledText styleClass="OraPromptText"
                                 textBinding="THRESHOLD_INFO@tablespaceBundle@servletRequest"
                                 renderedBinding="freeSpaceMetricAvail@thresholdsBean@servletRequest"/>

                            <uix:tableLayout width="100%">
                            <uix:rowLayout>

                            <%-- Tablespace Full : Space Used (%) --%>
                            <uix:cellFormat width="*" vAlign="top">

                              <uix:header textBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest">
                              <uix:stackLayout>

                                <%-- Space Used: Info Text --%>
                                <uix:styledText styleClass="OraPromptText"
                                     textBinding="SPACE_USED_INFO@tablespaceBundle@servletRequest"/>
                                <uix:spacer height="5"/>

                                <%-- Space Used: Use Database Default Thresholds --%>
                                <uix:tableLayout>
                                <uix:rowLayout>
                                  <uix:radioButton
                                       name="spaceThresholdsTbspcOption"
                                       textBinding="USE_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                                       selectedValueBinding="spaceThresholdsTbspcOption@thresholdsBean@servletRequest"
                                       valueBinding="THRESHOLDS_OPT_USE_DEFAULTS@thresholdsBean@servletRequest"/>
                                  <uix:spacer width="10"/>
                                  <uix:submitButton
                                       textBinding="MODIFY_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                                       name="event"
                                       value="modifyDefaultThresholds"
                                       formName="tbsThresholds"/>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                   <uix:labeledFieldLayout width="100%">
                                     <uix:messageStyledText 
                                        promptBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                                        shortDescBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                                        textBinding="spaceThresholdDbWarning@thresholdsBean@servletRequest" 
                                        contentStyleClass="OraDataText"/>
                                     <uix:messageStyledText 
                                        promptBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                                        shortDescBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                                        textBinding="spaceThresholdDbCritical@thresholdsBean@servletRequest" 
                                        contentStyleClass="OraDataText"/>
                                  </uix:labeledFieldLayout>
                                </uix:rowLayout>

                                <%-- Space Used: Specify Thresholds --%>
                                <uix:rowLayout>
                                  <uix:radioButton
                                       name="spaceThresholdsTbspcOption"
                                       textBinding="SPECIFY_BY_PERC_USED@tablespaceBundle@servletRequest"
                                       selectedValueBinding="spaceThresholdsTbspcOption@thresholdsBean@servletRequest"
                                       valueBinding="THRESHOLDS_OPT_USE_SPECIFIED@thresholdsBean@servletRequest"/>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:labeledFieldLayout>
                                    <uix:messageTextInput 
                                         name="spaceThresholdPercWarning"
                                         id="spaceThresholdPercWarning"
                                         promptBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                                         shortDescBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                                         columns="5"
                                         textBinding="spaceThresholdPercWarning@thresholdsBean@servletRequest">
                                        <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
                                    </uix:messageTextInput>
                                    <uix:messageTextInput 
                                         name="spaceThresholdPercCritical"
                                         id="spaceThresholdPercCritical"
                                         promptBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                                         shortDescBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                                         columns="5"
                                         textBinding="spaceThresholdPercCritical@thresholdsBean@servletRequest">
                                        <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
                                    </uix:messageTextInput> 
                                  </uix:labeledFieldLayout>
                                </uix:rowLayout>

                                <%-- Space Used: Disable Thresholds --%>
                                <uix:rowLayout>
                                  <uix:radioButton
                                       name="spaceThresholdsTbspcOption"
                                       textBinding="DISABLE_THRESHOLDS@tablespaceBundle@servletRequest"
                                       selectedValueBinding="spaceThresholdsTbspcOption@thresholdsBean@servletRequest"
                                       valueBinding="THRESHOLDS_OPT_DISABLE@thresholdsBean@servletRequest"/>
                                </uix:rowLayout>

                                </uix:tableLayout>

                              </uix:stackLayout>
                              </uix:header>

                            </uix:cellFormat>

                            <%-- Tablespace Full : Free Space (MB) --%>
                            <uix:cellFormat width="50%" 
                                            vAlign="top" 
                                            renderedBinding="freeSpaceMetricAvail@thresholdsBean@servletRequest">
                              <uix:header textBinding="FREE_SPACE_MB@tablespaceBundle@servletRequest">
                              <uix:stackLayout>

                                <%-- Free Space: Info Text --%>
                                <uix:styledText styleClass="OraPromptText"
                                     textBinding="FREE_SPACE_INFO@tablespaceBundle@servletRequest"/>
                                <uix:spacer height="5"/>

                                <%-- Free Space: Use Database Default Thresholds --%>
                                <uix:flowLayout>
                                  <uix:radioButton
                                     name="freeSpaceTbspcOption"
                                     textBinding="USE_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                                     selectedValueBinding="freeSpaceTbspcOption@thresholdsBean@servletRequest"
                                     valueBinding="THRESHOLDS_OPT_USE_DEFAULTS@thresholdsBean@servletRequest"/>
                                  <uix:spacer width="10"/>
                                  <uix:submitButton
                                     textBinding="MODIFY_DB_DEFAULT_THRESHOLDS@tablespaceBundle@servletRequest"
                                     name="event"
                                     value="modifyDbFreeSpaceThresholds"
                                     formName="tbsThresholds"/>
                                </uix:flowLayout>
                                <uix:labeledFieldLayout width="65%">
                                    <uix:messageStyledText 
                                         promptBinding="WARNING_MB@tablespaceBundle@servletRequest"
                                         shortDescBinding="WARNING_MB@tablespaceBundle@servletRequest"
                                         textBinding="freeSpaceDbWarning@thresholdsBean@servletRequest" 
                                         contentStyleClass="OraDataText"/>
                                    <uix:messageStyledText 
                                         promptBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                                         shortDescBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                                         textBinding="freeSpaceDbCritical@thresholdsBean@servletRequest" 
                                         contentStyleClass="OraDataText"/>
                                </uix:labeledFieldLayout>
 
                                <%-- Free Space: Specify Thresholds --%>
                                <uix:radioButton
                                     name="freeSpaceTbspcOption"
                                     textBinding="SPECIFY_BY_PERC_USED@tablespaceBundle@servletRequest"
                                     selectedValueBinding="freeSpaceTbspcOption@thresholdsBean@servletRequest"
                                     valueBinding="THRESHOLDS_OPT_USE_SPECIFIED@thresholdsBean@servletRequest"/>
                                <uix:labeledFieldLayout width="65%">
                                  <uix:messageTextInput 
                                       name="freeSpaceUserWarning"
                                       id="freeSpaceUserWarning"
                                       promptBinding="WARNING_MB@tablespaceBundle@servletRequest"
                                       shortDescBinding="WARNING_MB@tablespaceBundle@servletRequest"
                                       columns="10"
                                       textBinding="freeSpaceUserWarning@thresholdsBean@servletRequest">
                                      <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
                                  </uix:messageTextInput>
                                  <uix:messageTextInput 
                                       name="freeSpaceUserCritical"
                                       id="freeSpaceUserCritical"
                                       promptBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                                       shortDescBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                                       columns="10"
                                       textBinding="freeSpaceUserCritical@thresholdsBean@servletRequest"> 
                                      <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
                                  </uix:messageTextInput>
                                </uix:labeledFieldLayout>

                                <%-- Free Space: Disable Thresholds --%>
                                <uix:radioButton
                                     name="freeSpaceTbspcOption"
                                     textBinding="DISABLE_THRESHOLDS@tablespaceBundle@servletRequest"
                                     selectedValueBinding="freeSpaceTbspcOption@thresholdsBean@servletRequest"
                                     valueBinding="THRESHOLDS_OPT_DISABLE@thresholdsBean@servletRequest"/>

                              </uix:stackLayout>
                              </uix:header>
                            </uix:cellFormat>

                            </uix:rowLayout>
                            </uix:tableLayout> 
       
                          </uix:stackLayout>
                          </uix:header>
                          <%-- Threshold Options : END --%>


                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="notlocallymanaged">
                      <uix:styledText styleClass="OraInstructionText"
                          textBinding="TBSPC_THRESHOLDS_REQUIRE_LOCAL@tablespaceBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="noalertspackage">
                      <uix:styledText styleClass="OraInstructionText"
                          text="The DBMS_SERVER_ALERT package is not available on this database. This feature is not yet supported."/>
                    </uix:case>
                  </uix:switcher>
              </uix:subTabLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                <uix:ref refID="pageButtonInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

