<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Page:        viewPage.jsp
  -- Controller:  db/adm/stg/TablespaceController.java
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    05/01/09 - Add columnar compression supports (ER bug #8276145)
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
<uix:bundle name="tableMsg" class="oracle.sysman.db.rsc.schm.TableMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@mainEmoBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <uix:contents>

    <db:form name="foo" method="get" destinationBinding="defaultControllerURL@mainEmoBean@servletRequest" copyParams="target,type,cancelURL,oname,otype,guid,version,initMethod">
    <uix:formValue name="pageName" value="/database/storage/tablespace/viewPage"/>

    <uix:pageLayout titleBinding="header@mainEmoBean@servletRequest">

     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
     <%@ include file="/database/global.jspf" %>

       <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
       <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

       <%--uix:header textBinding="GENERAL@tablespaceBundle@servletRequest"
                   size="1"/--%>
       <uix:tableLayout cellSpacing="5">
         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="NAME@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="tablespaceName@defaultBean@servletRequest"/>
         </uix:rowLayout>
         

          <%-- Big File --%>
          <uix:switcher childNameBinding="notCreateand10i@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:switcher childNameBinding="locallyManaged@defaultBean@servletRequest">
                <uix:case name="true">    
                  <uix:switcher childNameBinding="singleDatafile@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="BFT_LABEL@tablespaceBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:styledText styleClass="OraDataText" textBinding="YES@uixDBObjectBundle@servletRequest"/>			
                      </uix:rowLayout>					  
                    </uix:case>
                    <uix:case name="false">
                      <uix:rowLayout>		    
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="BFT_LABEL@tablespaceBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:styledText styleClass="OraDataText" textBinding="NO@uixDBObjectBundle@servletRequest"/>	
                      </uix:rowLayout>
                    </uix:case>					
                  </uix:switcher>
                </uix:case>			  
              </uix:switcher>
            </uix:case>
          </uix:switcher>
      
         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="STATUS@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="modeType@generalPageUIBean@servletRequest"/>
         </uix:rowLayout>

         <%-- switcher for offline mode type..--%>
         <uix:switcher childNameBinding="currentlyOffline@generalPageUIBean@servletRequest">
         <uix:case name="true">
         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="OFFLINE_MODE@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="offlineMode@generalPageUIBean@servletRequest"/>
         </uix:rowLayout>
         </uix:case>
         </uix:switcher>


         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="TYPE@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="typeText@generalPageUIBean@servletRequest"/>
         </uix:rowLayout>

         <uix:switcher childNameBinding="defaultTemp@mainEmoBean@servletRequest">
         <uix:case name="true">
         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="DEFAULT_TEMP@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="YES@uixDBObjectBundle@servletRequest"/>
         </uix:rowLayout>
         </uix:case>
         </uix:switcher>

         <uix:switcher childNameBinding="defaultPermanent@mainEmoBean@servletRequest">
         <uix:case name="true">
         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt promptBinding="DEFAULT_PERMANENT@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="YES@uixDBObjectBundle@servletRequest"/>
         </uix:rowLayout>
         </uix:case>
         </uix:switcher>

         <%--Extent Management--%>
         <uix:rowLayout>
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt  promptBinding="EXTENT_MANAGEMENT@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="extentMgmtTypeText@extentMgmtUIBean@servletRequest"/>
         </uix:rowLayout>

	<uix:rowLayout renderedBinding="viewEncryptEnabled@defaultBean@servletRequest">
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt  promptBinding="ENCRYPTION@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="encrypted@defaultBean@servletRequest"/>
         </uix:rowLayout>
        	 
          
	<%--<uix:rowLayout renderedBinding="viewEncryptEnabled@defaultBean@servletRequest">
           <uix:cellFormat hAlign="right">
             <uix:messagePrompt  promptBinding="ENCRYPT_ALGO@tablespaceBundle@servletRequest"/>
           </uix:cellFormat>
           <uix:styledText styleClass="OraDataText"
                           textBinding="encryptAlgo@defaultBean@servletRequest"/>
         </uix:rowLayout> --%>

	<uix:rowLayout renderedBinding="undoAssignmentEnabled@defaultBean@servletRequest">
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="ASSIGNED_TO_INSTANCE@tablespaceBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:styledText styleClass="OraDataText"
                   textBinding="assignedInstance@defaultBean@servletRequest"/>
          </uix:rowLayout>

      </uix:tableLayout>


		<%-- Storage --%>
         <uix:header textBinding="STORAGE@tablespaceBundle@servletRequest"
                     size="1">
         <uix:switcher childNameBinding="local@extentMgmtBean@servletRequest">
         <uix:case name="true">
         <jsp:include page="/database/storage/tablespace/viewLocalStgPage.jsp" />
         <uix:ref refID="localStorageView" />
         </uix:case>
         <uix:case name="false">
         <jsp:include page="/database/storage/tablespace/viewDictStgPage.jsp" />
         <uix:ref refID="dictionaryStorageView" />
         </uix:case>
         </uix:switcher>

         <%-- bug 4294500, have to show extent info for converted locally managed tbsp --%>
         <uix:switcher childNameBinding="convertedLocalMgmtTbsp@extentMgmtBean@servletRequest">
           <uix:case name="true">
             <jsp:include page="/database/storage/tablespace/viewDictStgPage.jsp" />
             <uix:ref refID="dictionaryStorageView" />
           </uix:case>
         </uix:switcher>
       </uix:header>

	  <%-- Datafiles --%>

      <uix:header textBinding="DATAFILES@tablespaceBundle@servletRequest"
                          size="1">
      <oem:table name="datafilesTable"
                         width="100%"
                         destination="/console/database/storage/tablespace"
                         dataSourceProp="datafilesTable"
                         summaryBinding="DATAFILES@tablespaceBundle@servletRequest"
                         beanKey="datafilesUIBean" copyParams="target,type,oname,otype" >
      </oem:table>
      </uix:header>


	  <%-- Thresholds --%>
   <uix:header textBinding="THRESHOLD_OPTION@tablespaceBundle@servletRequest"
               renderedBinding="showViewThresholds@thresholdsBean@servletRequest">
     <uix:tableLayout width="100%">
     <uix:rowLayout>

         <%-- Tablespace Full : Space Used (%) --%>
         <uix:cellFormat width="*" vAlign="top">
           <uix:header textBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest">

           <uix:styledText 
                styleClass="OraPromptText" 
                textBinding="SPACE_USED_THRESHOLDS_ARE_DB_DEFAULTS@tablespaceBundle@servletRequest"
                renderedBinding="showSpaceUsedDefaultMsg@thresholdsBean@servletRequest"/>            

           <uix:labeledFieldLayout width="75%">
             <uix:messageStyledText 
                  promptBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                  shortDescBinding="WARNING_PERC@tablespaceBundle@servletRequest"
                  textBinding="viewSpaceUsedWarning@thresholdsBean@servletRequest" 
                  contentStyleClass="OraDataText"/>
             <uix:messageStyledText 
                  promptBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                  shortDescBinding="CRITICAL_PERC@tablespaceBundle@servletRequest"
                  textBinding="viewSpaceUsedCritical@thresholdsBean@servletRequest" 
                  contentStyleClass="OraDataText"/>
           </uix:labeledFieldLayout>
           </uix:header>
         </uix:cellFormat>

   <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
     <uix:case name="false">
         <%-- Tablespace Full : Free Space (MB) --%>
         <uix:cellFormat 
              width="50%" 
              vAlign="top"
              renderedBinding="freeSpaceMetricAvail@thresholdsBean@servletRequest">
           <uix:header textBinding="FREE_SPACE_MB@tablespaceBundle@servletRequest">

           <uix:styledText 
                styleClass="OraPromptText" 
                textBinding="FREE_SPACE_THRESHOLDS_ARE_DB_DEFAULTS@tablespaceBundle@servletRequest"
                renderedBinding="showFreeSpaceDefaultMsg@thresholdsBean@servletRequest"/>            

           <uix:labeledFieldLayout width="75%">
             <uix:messageStyledText 
                  promptBinding="WARNING_MB@tablespaceBundle@servletRequest"
                  shortDescBinding="WARNING_MB@tablespaceBundle@servletRequest"
                  textBinding="viewFreeSpaceWarning@thresholdsBean@servletRequest" 
                  contentStyleClass="OraDataText"/>
             <uix:messageStyledText 
                  promptBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                  shortDescBinding="CRITICAL_MB@tablespaceBundle@servletRequest"
                  textBinding="viewFreeSpaceCritical@thresholdsBean@servletRequest" 
                  contentStyleClass="OraDataText"/>
           </uix:labeledFieldLayout>
           </uix:header>
         </uix:cellFormat>

          </uix:case>
        </uix:switcher>
     </uix:rowLayout>
     </uix:tableLayout>
   </uix:header>


   <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
     <uix:case name="false">
     <uix:stackLayout>
   <%-- SYSAUX Usage --%>
      <uix:header textBinding="SYSAUX_USAGE_HDR@tablespaceBundle@servletRequest" 
                  renderedBinding="sysauxTablespace@defaultBean@servletRequest"
                  size="1">
          <uix:labeledFieldLayout labelWidth="20%">
            <uix:messagePrompt promptBinding="TOTAL_SPACE_USED_MB@tablespaceBundle@servletRequest"/>
            <uix:styledText styleClass="OraDataText" textBinding="totalOccupantSpaceUsed@defaultBean@servletRequest"/>            
            <uix:messagePrompt promptBinding="FREE_SPACE_MB@tablespaceBundle@servletRequest"/>
            <uix:styledText styleClass="OraDataText" textBinding="tbspFreeSpace@defaultBean@servletRequest"/>            

            <uix:messagePrompt promptBinding="SPACE_USED_PCT@tablespaceBundle@servletRequest"/>
            <uix:styledText styleClass="OraDataText" textBinding="spaceUsedPercent@defaultBean@servletRequest"/>            
          </uix:labeledFieldLayout>
          <uix:stackLayout>
          
            <oem:chart
              title="Usage"
              titleVisible="false"
              chartType="pieChart"
              width="250"
              height="200"
              hideZeroSlices="true"
              showSlicePercentLabels="true"
              legendVisible="external"
              legendPosition="east"
              pieValuesInLegend="percent"
              yAxisNumberFormatBinding="pieChartLegendFormat@defaultBean@servletRequest"
              >
                <oem:boundChartDataSource
                  chartDataSourceBinding="occupantPieChartDataSource@defaultBean@servletRequest"
                />
                <%-- Consumer Group --%>
                  <oem:chartColumn
                    displayLabel="label1"
                    sourceIndex="0"
                    isKey="true"                    
                  />
                  <%-- Consumed CPU Time --%>
                  <oem:chartColumn
                    displayLabel="label2"
                    sourceIndex="2"
                  />
            </oem:chart>            
          </uix:stackLayout>
        </uix:header>

        <uix:header textBinding="SYSAUX_OCCUPANTS_HDR@tablespaceBundle@servletRequest" 
                    renderedBinding = "sysauxTablespace@defaultBean@servletRequest"
                    size="1">
            <uix:stackLayout>
              <oem:table name="occupantsTable"
                         width="80%"
                         formSubmitted="true"
                         dataSourceProp="occupantsTable"
                         beanKey="occupantsUIBean" copyParams="target,type,oname,guid,version,initMethod"
                         alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
              </oem:table>
              <uix:spacer height="5"/>
            </uix:stackLayout>
          </uix:header>
        </uix:stackLayout>
      </uix:case>
    </uix:switcher>

  <uix:pageButtons>
    <uix:pageButtonBar>
        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
          <uix:case name="false">
              <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
              <uix:ref refID="storagePageButtonViewInclude" />
          </uix:case>
          <uix:case name="true">
          <%-- OK Button --%>
       <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
          </uix:case>
        </uix:switcher>
    </uix:pageButtonBar>
  </uix:pageButtons>

  </uix:pageLayout>
  </db:form>

</uix:contents>
</uix:body>
</uix:document>
</uix:renderingContext>


