<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="addTbsPageTitle@defaultBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>

     <db:form name="selectTbs" method="POST" destination="/console/database/storage/tmptbsgrp" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="addTbsPageHeader@defaultBean@servletRequest">
      
        <%@ include file="/database/global.jspf" %>
      
        <uix:formValue name="pageName" value="/database/storage/tmptbsgrp/addDelTmptbsPage"/>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        
                
        <oem:shuttle name="foobar" leadingHeaderBinding="AVAILTBS@tmptbsgrpBundle@servletRequest" trailingHeaderBinding="SELTBS@tmptbsgrpBundle@servletRequest" size="5" reorderable="false" >
          <uix:leading>
            <oem:list shortDescBinding="AVAILTBS@tmptbsgrpBundle@servletRequest" name="availableTbsNames" multiple="true" optionsBinding="availableTbsNames@defaultBean@servletRequest"/>
          </uix:leading>
          <uix:trailing>
            <oem:list shortDescBinding="SELTBS@tmptbsgrpBundle@servletRequest" name="selectedTbsNames" multiple="true" optionsBinding="selectedTbsNames@defaultBean@servletRequest"/>
          </uix:trailing>
        </oem:shuttle>
        <uix:messageText messageBinding="addTbs@errors@servletRequest" messageType="error"/>
        

        <uix:pageButtons>
          <uix:pageButtonBar>
            
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddTbs"/>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishAddTbs"/>
            
            
	        </uix:pageButtonBar>
        </uix:pageButtons>
        
      </uix:pageLayout>
      </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 


