<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form name="foo" method="post" destination="/console/database/storage/tmptbsgrp" copyParams="target,type,cancelURL,oname,otype">
    <uix:formValue name="pageName" value="/database/storage/tmptbsgrp/generalPage"/>

    
     
    <uix:pageLayout titleBinding="header@objectBean@servletRequest">
     <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
      <%@ include file="/database/global.jspf" %>

      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

     
      <uix:subTabLayout>
        

        <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:messagePrompt labeledNodeId="tmptbsgrpName"
                          promptBinding="NAME@uixDBObjectBundle@servletRequest" required="yes"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
     	          <uix:stackLayout>
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:textInput name="tmptbsgrpName"
                                     id="tmptbsgrpName" 
                                     textBinding="tmptbsgrpName@objectBean@servletRequest" columns="50"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText textBinding="tmptbsgrpName@objectBean@servletRequest" styleClass="OraDataText" />
                    </uix:case>
                  </uix:switcher>
                  <uix:messageText messageBinding="tmptbsgrpName@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
          </uix:rowLayout>
          

          <uix:switcher childNameBinding="default@objectBean@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:checkBox name="defaultTemp"
                      textBinding="CHECK_DEFAULT_TEMP_GRP@tmptbsgrpBundle@servletRequest"
                      shortDescBinding="CHECK_DEFAULT_TEMP_GRP@tmptbsgrpBundle@servletRequest"
                      checkedBinding="defaultTemp@objectBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
            <uix:case name="false">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="CHECK_DEFAULT_TEMP_GRP@tmptbsgrpBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <uix:styledText textBinding="defaulttext@objectBean@servletRequest" styleClass="OraDataText" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
          
       </uix:tableLayout>

        <uix:header textBinding="TMPTBS@tmptbsgrpBundle@servletRequest" size="1">
         <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
              <uix:submitButton textBinding="ADD_DEL_BTN@tmptbsgrpBundle@servletRequest" name="event" value="adddeltbs" /> 
              </uix:rowLayout>
              
              <uix:rowLayout>
               <oem:table name="tbsTableUI" beanKey="tbsBean" blockSize="25"
                    destinationBinding="/console/database/storage/tmptbsgrp" formSubmitted="true"
                    summaryBinding="TMPTBS@tmptbsgrpBundle@servletRequest"
                    dataSourceProp="tbsTableUI" alternateTextBinding="NO_TBS_SELECTED@tmptbsgrpBundle@servletRequest" copyParams="target,type" width="100%">
              <uix:tableSelection>
                
               </uix:tableSelection>
               </oem:table>
                
             
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:messageText messageBinding="tmptbsList@errors@servletRequest"
                               messageType="error"/>
            </uix:rowLayout>
            <uix:switcher childNameBinding="editingandtbssizeZero@objectBean@servletRequest"> 
             <uix:case name="true">
              <uix:rowLayout>
                <uix:stackLayout>
                    <uix:messagePrompt messageType="warning" promptBinding="deleteWarningMsg@objectBean@servletRequest" styleClass="OraMessageBoxParagraph"/>
                </uix:stackLayout>
              </uix:rowLayout>
             </uix:case>
            </uix:switcher>
      </uix:tableLayout>
      </uix:header>
      </uix:subTabLayout>
          

          <uix:pageButtons>
            <uix:pageButtonBar>

                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" name="event" value="showSql"/>
                        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel"/>
                        <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="apply"/>
                      </uix:rowLayout>
                    </uix:tableLayout> 
                  </uix:case>

                  <uix:case name="false">
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" name="event" value="showSql"/>
                        <uix:submitButton textBinding="REVERT@uixDBObjectBundle@servletRequest" name="event" value="revert" unvalidated="true"/>

                        <uix:switcher childNameBinding="editingandtbssizeZero@objectBean@servletRequest"> 
                          <uix:case name="true">
                            <uix:submitButton textBinding="APPLY@uixDBObjectBundle@servletRequest" name="event" value="delconfirm"/>
                          </uix:case>
                          <uix:case name="false">
                            <uix:submitButton textBinding="APPLY@uixDBObjectBundle@servletRequest" name="event" value="apply"/>
                          </uix:case>
                        </uix:switcher>
                        <uix:spacer width="10"/>

                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="ACTIONS@uixDBObjectBundle@servletRequest"/>

                        <uix:choice name="selectedOperationChoice"
                                    shortDescBinding="ACTIONS@uixDBObjectBundle@servletRequest"
                                    selectedValueBinding="selectedOperationChoice@operationsChoiceBean@servletRequest">
                          <uix:contents childDataBinding="operationsChoiceInfoForEdit@operationsChoiceBean@servletRequest">
                            <uix:option textBinding="textKey"
                                        valueBinding="valueKey"/>
                          </uix:contents>
                        </uix:choice>
                        <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="operationsGo"/>
                      </uix:rowLayout>
                    </uix:tableLayout> 
                  </uix:case>
                </uix:switcher>
            
            </uix:pageButtonBar>
          </uix:pageButtons>

         <uix:pageButtons>
            <uix:pageButtonBar>
              <jsp:include page="/database/schema/pageButtonInclude.jsp" />
              <uix:ref refID="pageButtonInclude" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
      </uix:body>

     </uix:document>
    </uix:renderingContext>

