<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>

  
  <uix:body>
  <db:form name="foo" method="post" destination="/console/database/storage/tmptbsgrp" copyParams="target,type,cancelURL,oname,otype">
  <uix:formValue name="pageName" value="/database/storage/tmptbsgrp/viewTmpgrpPage"/>
  <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
    <%@ include file="/database/global.jspf" %>
    
    
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
       <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="tmptbsgrpName@objectBean@servletRequest"/>
      </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="CHECK_DEFAULT_TEMP_GRP@tmptbsgrpBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText textBinding="defaulttext@objectBean@servletRequest" styleClass="OraDataText" />
            </uix:cellFormat>
      </uix:rowLayout>
      </uix:tableLayout>
      <uix:header textBinding="TMPTBS@tmptbsgrpBundle@servletRequest">
      <uix:tableLayout width="100%">
      <uix:rowLayout>
        <oem:table name="tbsTableUI" beanKey="tbsBean" blockSize="10"
                    destinationBinding="/console/database/storage/tmptbsgrp" formSubmitted="true"
                    summaryBinding="TMPTBS@tmptbsgrpBundle@servletRequest"
                    dataSourceProp="tbsTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" copyParams="target,type" width="100%">
        </oem:table>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
    
    <uix:pageButtons>
       <uix:pageButtonBar>
         <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
         <uix:ref refID="storagePageButtonViewInclude" />
		  </uix:pageButtonBar>
    </uix:pageButtons>
       
      </uix:pageLayout>
       </db:form>
      </uix:body>
   
</uix:document>
</uix:renderingContext>  

