<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
 <uix:document>

  <uix:metaContainer>
   <uix:head titleBinding="STG_DEPEND_TITLE@uixDBObjectBundle@servletRequest"/>	
  </uix:metaContainer>

  <uix:body>
    <db:form name="foo" method="POST" destinationBinding="destination@servletRequest" 
		copyParams="target,type,itemName,oname,otype,sname">
    <uix:formValue name="pageName" value="/database/storage/topologyDepend"/>  

    <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
    <uix:pageLayout titleBinding="STG_DEPEND_HEADER@uixDBObjectBundle@servletRequest">

    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- topology dependent hgrid --%>

    <uix:header textBinding="STG_DEPEND_VIEWTREE@uixDBObjectBundle@servletRequest">
    <uix:hGrid id="topologyDepend" width="60%" 
               alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
               summaryBinding="STG_DEPEND_VIEWTREE@uixDBObjectBundle@servletRequest"
               treeDataBinding="treeData@topologyItem@servletRequest"
               destinationBinding="destination@topologyItem@servletRequest"
               proxyBinding="proxy@servletRequest"
	             formSubmitted="true">

              <uix:nodeStamp>
               <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="NAME@uixDBObjectBundle@servletRequest"/>
                </uix:columnHeader>
	        <uix:flowLayout>
	         <uix:contents>
	          <uix:image sourceBinding="source"
			     heightBinding="height"
			     widthBinding="width"/>
	           <uix:spacer width="5"/>
                   <uix:styledText styleClass="OraFieldText" 
			           textBinding="text" />
	         </uix:contents>
	        </uix:flowLayout>
               </uix:column>
              </uix:nodeStamp>
       </uix:hGrid>

    </uix:header>
    <uix:spacer height="5"/>

    <uix:header textBinding="STG_DEPEND_VIEWLIST@uixDBObjectBundle@servletRequest">    
    <%-- topology dependent table --%>
    <uix:tableLayout>
     <oem:table  
          width="60%" 
          alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
          summaryBinding="STG_DEPEND_VIEWLIST@uixDBObjectBundle@servletRequest"
		      blockSize="25"
     		  name="elemDependTable" 
		      formSubmitted="true"		 
     		  dataSourceProp="elemDependTable"
      		beanKey="topologyItem"/>
    </uix:tableLayout>
    </uix:header>

    <%-- cancel buttons --%>	

    <uix:pageButtons>
     <uix:pageButtonBar>
      <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                        name="event" value="finish"/>
     </uix:pageButtonBar>
    </uix:pageButtons>

   </uix:pageLayout>
  </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>

