<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
 <uix:document>

  <uix:metaContainer>
   <uix:head titleBinding="STG_DETAIL_TITLE@uixDBObjectBundle@servletRequest"/>	
  </uix:metaContainer>

  <uix:body>
    <db:form name="foo" method="POST" destinationBinding="destination@servletRequest"
	      copyParams="target,type,itemName,oname,otype,sname">
    <uix:formValue name="pageName" value="/database/storage/topologyDetail"/>  

    <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->

    <uix:pageLayout titleBinding="STG_DETAIL_HEADER@uixDBObjectBundle@servletRequest">

    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="info"
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>	

    <%-- topology item properties --%>
    <uix:header textBinding="STG_DETAIL_ELEMENT@uixDBObjectBundle@servletRequest">

    <uix:tableLayout width="100%">
     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="NAME@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="elemName@topologyItem@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>

     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="TYPE@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="elemType@topologyItem@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>

     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="DESCRIPTION@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="elemDesc@topologyItem@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>

     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="NUM_SUB_ELEMENTS@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="numSubElem@topologyItem@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>

     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="ELEMENT_SIZE@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="elemSize@topologyItem@servletRequest"/>
	<uix:spacer width="2"/>
       <uix:styledText styleClass="OraDataText" textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>

     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="STRIPE_SIZE@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="stripeSize@topologyItem@servletRequest"/>
       <uix:styledText styleClass="OraDataText" textBinding="KBYTES@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>

     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="25%">
       <uix:styledText styleClass="OraPromptText" textBinding="OBJSIZE_ON_ELEMENT@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
       <uix:spacer width="3"/>
      <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="objSizeOnElem@topologyItem@servletRequest"/>
       <uix:styledText styleClass="OraDataText" textBinding="MBYTES@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
     </uix:rowLayout>
    </uix:tableLayout>

    </uix:header>

    <%-- topology item supplimentary information --%>
    <uix:spacer height="5"/>

    <uix:header textBinding="STG_DETAIL_SUPPLEM@uixDBObjectBundle@servletRequest">

    <uix:tableLayout>
     <oem:table  width="60%"
		 alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
                 summaryBinding="STG_DETAIL_SUPPLEM@uixDBObjectBundle@servletRequest" 
		 blockSize="25"
		 name="elemDetailTable" 
		 dataSourceProp="elemDetailTable"
		 beanKey="topologyItem"/>
    </uix:tableLayout>

    </uix:header>

<%-- refresh and drop map	
    <uix:tableLayout>
     <uix:rowLayout>
      <uix:cellFormat hAlign="right" width="30%">
       <uix:submitButton disabledBinding="mappingDisabled@defaultBean@servletRequest"
			 textBinding="REFRESH_MAP@uixDBObjectBundle@servletRequest" 
			 name="event" value="refreshMap"/>
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
       <uix:submitButton textBidisabledBinding="mappingDisabled@defaultBean@servletRequest"
			 nding="DROP_MAP@uixDBObjectBundle@servletRequest" 
			 name="event" value="dropMap"/>
      </uix:cellFormat>
     </uix:rowLayout>
    </uix:tableLayout>
--%>

    <%-- cancel buttons --%>	

    <uix:pageButtons>
     <uix:pageButtonBar>
      <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                        name="event" value="finish"/>
     </uix:pageButtonBar>
    </uix:pageButtons>

   </uix:pageLayout>
  </db:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>

