<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.PageNames" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>


  <uix:document>
 
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="indexStatisticsProcessing" method="post">
          <uix:pageLayout>

            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header
                text="Retrieving Statistics and Size Info for Text Index:"
                icon="/em/images/processl.gif">

              <uix:borderLayout>
                <uix:left>
                  <uix:styledText
                      styleClass="OraDataText"
                      text="Retrieving"/>
                </uix:left>
              </uix:borderLayout>

              <uix:tableLayout width="100%" hAlign="center">


                <uix:rowLayout>
                  <uix:spacer height="20"/>
                </uix:rowLayout>
 
                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:processing
                            id="executeProcessingControl"
                            timeInterval="2000">
                          <uix:contents>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>


          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

