<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="txtMsgs" class="oracle.sysman.db.rsc.txt.TextMsg"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

        <uix:document>
          <uix:metaContainer>
            <uix:head titleBinding="editPageTitle@servletRequest"/>
          </uix:metaContainer>
          
            <uix:body>
              <uix:dataScope currentDataBinding="partitionList@servletRequest">
                 <db:form name="form0" method="get"
		 destination="/console/database/txt/editTextIndex" copyParams="target,type,indexNameOrig,owner">
                    <uix:formValue name="pageName" value="/database/txt/partitions"/>
					
					
                    <uix:pageLayout titleBinding="pageMainHead@servletRequest">
                      <%@ include file="/database/global.jspf" %>
					<uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="PARTITION_PAGE_INFO@txtMsgs"/>
                      </uix:pageStatus>
				
				    <uix:tableLayout cellSpacing="10"   width="100%" >
						<uix:rowLayout hAlign="left">
						<uix:tableLayout cellSpacing="10" width="50%">
                              
                                
                               
                                <uix:rowLayout>
                                  
                                    <uix:cellFormat hAlign="right">
                                      
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="TABLE_PARTN_METHOD@txtMsgs"/>
                                      
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      
                                        <uix:messageStyledText  styleClass="OraDataText" textBinding="tablePartnMethod"/>
                                      
                                    </uix:cellFormat>
                                  
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  
                                    <uix:cellFormat hAlign="right">
                                                              
                                        <uix:messageStyledText styleClass="OraInstructionText" textBinding="INDEX_PARTN_METHOD@txtMsgs"/>
                                      
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      
                                        <uix:messageStyledText  styleClass="OraDataText" textBinding="indexPartnMethod"/>
                                      
                                    </uix:cellFormat>
                                  
                                </uix:rowLayout>
                                
                              
                            </uix:tableLayout>
                          </uix:rowLayout>
							<uix:rowLayout width="100%">
						<uix:table name="partitionsList" alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
		                formSubmitted="true" width="70%" tableDataBinding="rowData" valueBinding="startIndex"
		                maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize" shortDescBinding="PARTITION_LIST@txtMsgs" summaryBinding="PARTITION_LIST@txtMsgs">

               <uix:column>
                     <uix:columnHeader>
                         <uix:sortableHeader textBinding="PARTITION_NAME@txtMsgs" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="60%"/>
                     <uix:text textBinding="partnNameIndex" />
               </uix:column>

               <uix:column rendered="false">
                     <uix:columnHeader>
                        <uix:sortableHeader textBinding="SYNC_MODE@txtMsgs" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                     <uix:text  textBinding="synModeIndex"/>
               </uix:column>

               <uix:column>
                     <uix:columnHeader>
                        <uix:sortableHeader textBinding="STATUS@txtMsgs" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                     <uix:text textBinding="statusIndex" />
               </uix:column>
				<uix:tableSelection>
                 <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbMsgs" />                                   
				</uix:tableSelection>
                              
          </uix:table>
		  </uix:rowLayout>
		  </uix:tableLayout>
				
					  <uix:pageButtons>
                       
                        <uix:pageButtonBar>                         
                          <uix:submitButton shortDescBinding="CANCEL@@txtMsgs" textBinding="CANCEL@@txtMsgs" name="event" value="cancel"/>
                           <uix:submitButton textBinding="CONTINUE@@txtMsgs" shortDescBinding="CONTINUE@txtMsgs" name="event" value="continue"/>                                           
                       </uix:pageButtonBar>
               
                      </uix:pageButtons>
                      
                      
                    </uix:pageLayout>
                  
                </db:form>
              </uix:dataScope>
            </uix:body>
          
        </uix:document>
</uix:renderingContext>
