<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf"%>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="txtMsgs" class="oracle.sysman.db.rsc.txt.TextMsg"/>
<uix:bundle name="dbMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>
    
        <uix:document>
          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="pageTitle@servletRequest"/>
          </uix:metaContainer>
          
            <uix:body>
              <uix:dataScope currentDataBinding="queryList@servletRequest">
                <db:form name="form0" method="post">
                    <uix:formValue  name="lovName"/> 
                    <uix:pageLayout titleBinding="pageHeader@servletRequest">
                      <%@ include file="/database/global.jspf" %>
                          <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
                        <uix:tableLayout width="100%">
                          
                            <uix:rowLayout>
                              
                                <uix:cellFormat>
                                  
                                    <uix:header textBinding="QUERY_CRITERIA@txtMsgs">
                                      
                                        <uix:tableLayout cellSpacing="9" >
                                          
                                            <uix:rowLayout vAlign="top">
                                              
                                                <uix:cellFormat hAlign="right" width="32%">
                                                  
                                                    <uix:messageStyledText textBinding="INDEX_NAME@txtMsgs" styleClass="OraInstructionText"   messageBinding="selIndexNameerr@servletRequest" messageTypeBinding="selIndexNameerrtype@servletRequest" />
                                                  
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                  
                                                    <uix:messageLovField name="indexName" id="indexName" textBinding="selectedIndexName@servletRequest" columns="40" onClick = "document.forms[0].lovName.value= 'indexName';window.open('/em/console/target/sel/postBackWithEvent?eventParam=listIndexes','lovWindow','width=750, height=550');" />
                                                  
                                                </uix:cellFormat>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout vAlign="top">
                                              
                                                <uix:cellFormat hAlign="right">
                                                  
                                                    <uix:messageStyledText textBinding="NUM_ROWS_FETCH@txtMsgs" styleClass="OraInstructionText"  messageBinding="numRowsErr@servletRequest" messageTypeBinding="numRowsErrType@servletRequest"/>
                                                  
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                  
                                                    <uix:messageTextInput columns="10" name="numRowsToFetch" textBinding="numRowsToFetch@servletRequest" />






















							
                                                    
                                                  
                                                </uix:cellFormat>
                                              
                                            </uix:rowLayout>
                                            <uix:rowLayout vAlign="top">
                                              
                                                <uix:cellFormat hAlign="right">
                                                  
                                                    <uix:spacer height="10" width="10"/>
                                                  
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                  
                                                    <uix:submitButton textBinding="GO@txtMsgs" event="goQry"/>
                                                  
                                                </uix:cellFormat>
                                              
                                            </uix:rowLayout>
                                          
                                        </uix:tableLayout>
                                      
                                    </uix:header>
                                  
                                </uix:cellFormat>
                              
                            </uix:rowLayout>
                            <uix:rowLayout>
                              
                                <uix:cellFormat vAlign="top" width="50%">
                                  
                                    <uix:header textBinding="resultTitle@servletRequest">
                                      
                                        <uix:table name="queryList"   formSubmitted="true" width="90%" tableDataBinding="rowData" valueBinding="startIndex"
						                maxValueBinding="numRows"  minValue="1" blockSizeBinding="blockSize"  >
                                          
                                          
                                            <uix:column>
                             <uix:columnFormat cellNoWrapFormat="false" width="55%"/>
                                              <uix:columnHeader>
                                            
                                                <uix:sortableHeader sortable="no" textBinding="QUERY@txtMsgs" tip="Tip 0"/>
                                              </uix:columnHeader>
                                              
                                                <uix:styledText styleClass="OraInstructionText" textBinding="query"/>
                                              
                                            </uix:column>
                                            <uix:column>
                             <uix:columnFormat cellNoWrapFormat="false" width="35%"/>
                                              <uix:columnHeader>
                                                <uix:sortableHeader sortable="no" textBinding="PARTITION@txtMsgs" tip="Tip 0"/>
                                              </uix:columnHeader>
                                              
                                                <uix:styledText textBinding="partition"/>
                                              
                                            </uix:column>
                                            <uix:column>
                                              <uix:columnFormat columnDataFormat="numberFormat"/>
                                              <uix:columnHeader>









                                                <uix:sortableHeader sortable="no" textBinding="DURATION@txtMsgs" tip="Tip 0"/>
                                              </uix:columnHeader>
                                              
                                                <uix:styledText styleClass="OraInstructionText" textBinding="duration"/>
                                              
                                            </uix:column>
                                          
                                          <uix:tableSelection/>
                                          <uix:tableActions/>
                                        </uix:table>
                                      
                                    </uix:header>
                                  
                                </uix:cellFormat>
                              
                            </uix:rowLayout>
                            <uix:rowLayout>
 				<uix:contents>
                          		<uix:spacer width="10" height="10"/>
                        	</uix:contents>

                            </uix:rowLayout>

                                                   <uix:rowLayout width="100%" hAlign="left">

                                <uix:cellFormat hAlign="left">

                                    <uix:header shortDescBinding="RELATED_LINKdbMsg"  textBinding="RELATED_LINK@dbMsg" >
                                      <uix:contents>
                                        <uix:rowLayout>
                                         <uix:cellFormat>
                                          <uix:contents>
<db:link 
shortDescBinding="ENABLE_DISABLE_QUERY_LOG@txtMsgs" 
textBinding="ENABLE_DISABLE_QUERY_LOG@txtMsgs" 
destination="/console/database/txt/queryLogs?event=endisqlog&otype=schema"  copyParams="target,type"/>

                                          </uix:contents>
                                        </uix:cellFormat>

                                        </uix:rowLayout>

    </uix:contents>
                                    </uix:header>

                                </uix:cellFormat>

                            </uix:rowLayout>


                          
                        </uix:tableLayout>

                      
                      
                    
                      
                      
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="QUERY_STATISTICS_INFO@txtMsgs"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </db:form>
              </uix:dataScope>
            </uix:body>
          
        </uix:document>
    </uix:renderingContext>  
