<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>
<%@ page import="oracle.sysman.emo.txt.TextIndexHealthList"%>
<%@ page import="oracle.sysman.emo.txt.TextIndexHealthDetails"%>

<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.HashMap"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<db:script src="/database/txt/lovUtil.js"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<%
          TextIndexHealthList bean = (TextIndexHealthList)request.getAttribute("HEALTH_BEAN");
          boolean partitionedFlag = bean.getSelectedIndexDetails().isPartitioned();
          Long fragmentPercent = bean.getSelectedIndexDetails().getFragmentPercent();
          String indexName = bean.getSelectedIndexName();
          String indexOwner = bean.getSelectedIndexOwner();
          boolean _11gOrHigher = bean.getIfVersion11OrHigher();

          String optimizeType = (String) request.getAttribute("OPTIMIZE_TYPE"); 


          String defaultLogFileName = "CTX_"+optimizeType.toUpperCase()+"_OPTMZ_"+ indexName + ".log";

          String logFileName = (String)request.getAttribute("logFileName");

          if (logFileName == null)
           logFileName = defaultLogFileName;


          String logFileTip = defaultLogFileName;


         Boolean showParallelDegree = new Boolean(false);

         if(
            optimizeType.equals("Full") ||
            optimizeType.equals("Token Type")
           )
        {
             showParallelDegree = new Boolean(true);
        }

         Boolean showOptimizeTimeOut = new Boolean(false);

         if( optimizeType.equals("Full"))
        {
              showOptimizeTimeOut = new Boolean(true);
        }

       boolean showToken = false;

         if( optimizeType.equals("Token"))
        {
              showToken = true;
        }

       boolean showTokenType = false;

       if(
            optimizeType.equals("Token") ||
            optimizeType.equals("Token Type")
           )
        {
             showTokenType = true;
        }

          String  logDir = bean.getCurrentLogDirectory();

     
 %>
<uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="textRB" class="oracle.sysman.db.rsc.txt.TextMsg"/>
<%
             StringBuffer oemTitle =  (StringBuffer)request.getAttribute("_emSDK_PageTitle");
             oemTitle.append("-");
             oemTitle.append((String)request.getAttribute("optimizeTitle"));

%>

        <uix:document>
          <%@ include file="/oemTitle.jspf" %>
                        <uix:metaContainer>
            <uix:head title="<%=oemTitle%>"/>
          </uix:metaContainer>

            <uix:body>
              <uix:contents>
                <uix:form name="form0" method="post">
                  <uix:formValue  name="lovName"/>
                  <uix:contents>
                    <uix:pageLayout titleBinding="optimizeTitle@servletRequest">
                      <%@ include file="/oemGlobal.jspf" %>
                         <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
                      <uix:contents>
                        <uix:tableLayout width="100%">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout vAlign="top">
                              <uix:contents>
                                <uix:cellFormat vAlign="top" width="50%">
                                  <uix:contents>
                                    <uix:tableLayout cellSpacing="10">
                                      <uix:contents>

<% if (!partitionedFlag) {%>
                                        <uix:rowLayout rendered="false">
                                          <uix:contents>
                                            <uix:cellFormat hAlign="right">
                                              <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="FRAGMENT_PERCENT@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="left">
                                              <uix:contents>
                                                <uix:messageStyledText  styleClass="OraDataText" text="<%=fragmentPercent.longValue()%>"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                       <uix:rowLayout vAlign="top" rendered="<%=showParallelDegree%>">
                                          <uix:contents>
                                            <uix:cellFormat hAlign="right" width="20%">
                                              <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="PARALLEL_DEGREE@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:messageTextInput columns="15" name="pDegree" messageBinding="pDegreeErrMsg@servletRequest" messageTypeBinding="pDegreeErrType@servletRequest" textBinding="pDegree@servletRequest"  tipBinding="PARALLEL_DEGREE_TIP@textRB" shortDescBinding="PARALLEL_DEGREE@textRB">
                                                <uix:onBlurValidater>
                                                   <uix:decimal maxScale="0"/>
                                                </uix:onBlurValidater>
                                                </uix:messageTextInput>

                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>

                                          <uix:rowLayout vAlign="top" rendered="<%=showOptimizeTimeOut%>">
                                          <uix:contents>
                                            <uix:cellFormat hAlign="right" width="20%">
                                              <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="MAX_OPTIMIZE_TIME@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:messageTextInput columns="15" name="timeOut" messageBinding="timeOutErrMsg@servletRequest" messageTypeBinding="timeOutErrType@servletRequest" textBinding="timeOut@servletRequest"  tipBinding="TIME_OUT_TIP@textRB" shortDescBinding="MAX_OPTIMIZE_TIME@textRB">
                                                <uix:onBlurValidater>
                                                   <uix:decimal maxScale="0"/>
                                                </uix:onBlurValidater>
                                                </uix:messageTextInput>

                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>


<%}%>

<% if (showToken) {%>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat hAlign="right" >
                                              <uix:contents>
                                               <uix:messageStyledText styleClass="OraInstructionText" textBinding="TOKEN@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat >
                                            <uix:cellFormat hAlign="left">
                                              <uix:contents>
                                                <uix:messageTextInput required="true"  columns="25" styleClass="OraDataText" name="token" textBinding="token@servletRequest"  messageBinding="tokenerr@servletRequest" messageTypeBinding="tokenerrtype@servletRequest" shortDescBinding="TOKEN@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
<%}%>

<% if (showTokenType) {%>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat hAlign="right" >
                                              <uix:contents>
                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="TOKEN_TYPE@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                            <uix:cellFormat hAlign="left">
                                              <uix:contents>
                                                <uix:messageLovField columns="25" styleClass="OraDataText" name="tokenType" textBinding="tokenType@servletRequest" messageBinding="tokenTypeerr@servletRequest" messageTypeBinding="tokenTypeerrtype@servletRequest"  id="tokenType"  onClick = "openTokenTypeSelWindow('tokenType');" shortDescBinding="TOKEN_TYPE@textRB" searchDescBinding="TOKEN_TYPE@textRB"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
<%}%>
                                      </uix:contents>
                                    </uix:tableLayout>

<%if (partitionedFlag) { %>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat vAlign="top" width="50%">
                                  <uix:contents>
                                  <uix:dataScope currentDataBinding="OPTIMIZE_DS@servletRequest">
                                     <uix:table name="OPTIMIZE_TABLE" alternateTextBinding="NO_ITEMS_FOUND@textRB" width="85%" formSubmitted="true"                                                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                     minValue="1"
                                                     valueBinding="<%=UIXDataSource.S_START_INDEX_ATTR%>"
                                                     blockSizeBinding="<%=UIXDataSource.S_BLOCK_SIZE_ATTR%>"
                                                     maxValueBinding="<%=UIXDataSource.S_NUM_ROWS_ATTR%>" summaryBinding="PARTITION_LIST@textRB" shortDescBinding="PARTITION_LIST@textRB">
                                             <uix:tableFormat tableBanding="rowBanding"/>

                                      <uix:contents>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="yes" textBinding="PARTITION_NAME@textRB"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" textBinding="pName"/>
                                          </uix:contents>
                                        </uix:column>
                                         <uix:column rendered="<%=showParallelDegree%>">
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="PARALLEL_DEGREE@textRB" />
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:tableLayout hAlign="center">
                                              <uix:contents>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:cellFormat hAlign="center">
                                                      <uix:contents>
                                                        <uix:messageTextInput columns="10" name="pDegree" textBinding="pDegree" shortDescBinding="PARALLEL_DEGREE@textRB">
                                                          <uix:onBlurValidater>
                                                            <uix:decimal maxScale="0"/>
                                                          </uix:onBlurValidater>
                                                        </uix:messageTextInput>
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:tableLayout>
                                          </uix:contents>
                                        </uix:column>
                                         <uix:column rendered="<%=showOptimizeTimeOut%>">
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="MAX_OPTIMIZE_TIME@textRB" />
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:tableLayout hAlign="center">
                                              <uix:contents>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:cellFormat hAlign="center">
                                                      <uix:contents>
                                                        <uix:messageTextInput columns="10" name="timeOut" textBinding="timeOut" shortDescBinding="MAX_OPTIMIZE_TIME@textRB">
                                                          <uix:onBlurValidater>
                                                            <uix:decimal maxScale="0"/>
                                                          </uix:onBlurValidater>
                                                        </uix:messageTextInput>
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:tableLayout>
                                          </uix:contents>
                                        </uix:column>

                                        <uix:column rendered="false">
                                          <uix:columnFormat columnDataFormat="numberFormat"/>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="FRAGMENT_PERCENT@textRB" />
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText textBinding="fragmentPercent"/>
                                          </uix:contents>
                                        </uix:column>
                                      </uix:contents>
                                      <uix:tableSelection>
                                        <uix:multipleSelection textBinding="TABLE_PROMPT@textRB" selectedBinding="selectedItems" shortDescBinding="TABLE_PROMPT@textRB"/>
                                      </uix:tableSelection>
                                     <uix:tableActions/>
                                    </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
<%}%> 
                         <%@ include file="/database/txt/textIndexLogging.jspf" %>

                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>

                      </uix:contents>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="SHOW_SQL@textRB" event="fastOptimizeShowSql" shortDescBinding="SHOW_SQL@textRB"/>
                            <uix:submitButton textBinding="CANCEL@textRB" event="onOptimizeCancel" shortDescBinding="CANCEL@textRB"/>
                            <uix:submitButton textBinding="NEXT@textRB" event="optimizeFastSubmit" shortDescBinding="NEXT@textRB"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      <uix:pageStatus>
                        <uix:formattedText styleClass="OraInstructionText" textBinding="optimizeIntro@servletRequest"/>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  </uix:contents>
 </uix:form>
              </uix:contents>
            </uix:body>
        </uix:document>
</uix:renderingContext>
