<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<db:script src="/database/txt/lovUtil.js"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="textRB" class="oracle.sysman.db.rsc.txt.TextMsg"/>


        <uix:document>
          <%@ include file="/oemTitle.jspf" %>
                        <uix:metaContainer>
            <uix:head titleBinding="TOKEN_TYPE_PROMPT@textRB"/>
          </uix:metaContainer>

            <uix:body>
              <uix:contents>
                <uix:form name="form0" method="post">
                  <uix:contents>
                    <uix:formValue name="lovName" valueBinding="lovName@servletRequest"/>
                    <uix:pageLayout titleBinding="TOKEN_TYPE_PROMPT@textRB">
                         <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat vAlign="top" width="50%">
                                  <uix:contents>
                                  <uix:dataScope currentDataBinding="TOKEN_TYPE_DS@servletRequest">
                                     <uix:table name="TOKEN_TYPE_TABLE" alternateTextBinding="NO_ITEMS_FOUND@textRB" width="85%" formSubmitted="true"                                                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                     minValue="1"
                                                     id="TOKEN_TYPE_TABLE"
                                                     proxied="true"
                                                     valueBinding="<%=UIXDataSource.S_START_INDEX_ATTR%>"
                                                     blockSizeBinding="<%=UIXDataSource.S_BLOCK_SIZE_ATTR%>"
                                                     maxValueBinding="<%=UIXDataSource.S_NUM_ROWS_ATTR%>" shortDescBinding="TOKEN_TYPE_SUMMARY@textRB" summaryBinding="TOKEN_TYPE_SUMMARY@textRB">
                                             <uix:tableFormat tableBanding="rowBanding"/>

                                      <uix:contents>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="TOKEN_TYPE@textRB"/>
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" textBinding="tokentype"/>
                                          </uix:contents>
                                        </uix:column>
                                        <uix:column>
                                          <uix:columnHeader>
                                            <uix:sortableHeader sortable="no" textBinding="DESCRIPTION@textRB" />
                                          </uix:columnHeader>
                                          <uix:contents>
                                            <uix:styledText styleClass="OraInstructionText" textBinding="descr"/>
                                          </uix:contents>
                                        </uix:column>
                                      </uix:contents>
                                      <uix:tableSelection>
                                        <uix:singleSelection textBinding="TABLE_PROMPT@textRB" shortDescBinding="TABLE_PROMPT@textRB"/>
                                      </uix:tableSelection>
                                     <uix:tableActions/>
                                    </uix:table>
                                    </uix:dataScope>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                            <uix:submitButton textBinding="CANCEL@textRB" onClick="top.close()" shortDescBinding="CANCEL@textRB"/>
                            <uix:submitButton textBinding="SUBMIT@textRB" onClick="myTokenTypeSel();" shortDescBinding="SUBMIT@textRB"/>
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
              </uix:contents>
            </uix:body>
        </uix:document>
</uix:renderingContext>
