<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@usageSearchBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="type,cancelURL,oname,otype"
        name="featureDrillForm" 
        method="post"
        destination="/console/database/usage/search">

        <uix:formValue 
          name="pageName" 
          value="/database/usage/search/searchFeatureDrilldown"/>

        <uix:pageLayout
          titleBinding="header@usageSearchBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-----------------------------
           -  Labeled Fields
           -----------------------------%>
          <uix:labeledFieldLayout width="75%" >

            <%------------------------
             -  Hostname
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="HOSTNAME@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="hostname@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Database Name
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="DATABASE@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="database@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Instance Name
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:switcher 
              childNameBinding="targetType@usageSearchBean@servletRequest">
              <uix:case name="oracle_database">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="INSTANCE_NAME@dbFeatureUsageBundle@servletRequest" />
              </uix:case>
            </uix:switcher>

            <%---  Field  ---%>
            <uix:switcher 
              childNameBinding="targetType@usageSearchBean@servletRequest">
              <uix:case name="oracle_database">
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="instanceName@usageSearchBean@servletRequest"/>
              </uix:case>
            </uix:switcher>

            <%------------------------
             -  Version 
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="VERSION@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="version@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Feature Name
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="FEATURE_NAME@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="featureName@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Description
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="DESCRIPTION@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="description@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Detected Usages
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="DETECTED_USAGES@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="detectedUsages@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Total Samples
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="TOTAL_SAMPLES@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="totalSamples@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Currently Used
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="CURRENTLY_USED@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="currentlyUsed@usageSearchBean@servletRequest"/>

            <%------------------------
             -  First Usage Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="FIRST_USAGE_DATE@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="firstUsageDate@usageSearchBean@servletRequest"/>

            <%------------------------
             - Last Usage Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="LAST_USAGE_DATE@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="lastUsageDate@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Last Sample Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="LAST_SAMPLED_AT@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="lastSampleDate@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Next Sample Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="NEXT_SAMPLED_AT@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="nextSampleDate@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Last Sample Period
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="LAST_SAMPLE_PERIOD@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="lastSamplePeriod@usageSearchBean@servletRequest"/>

            <%------------------------
             -  Aux Count
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:switcher 
              childNameBinding="auxCountNull@usageSearchBean@servletRequest">
              <uix:case name="false">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="COUNT@dbFeatureUsageBundle@servletRequest" />
              </uix:case>
            </uix:switcher>

            <%---  Field  ---%>
            <uix:switcher 
              childNameBinding="auxCountNull@usageSearchBean@servletRequest">
              <uix:case name="false">
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="auxCount@usageSearchBean@servletRequest"/>
              </uix:case>
            </uix:switcher>

          </uix:labeledFieldLayout>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="cancel"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
