<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer> 
      <uix:head
        titleBinding="SEARCH_FEATURE_USAGE_TITLE@dbFeatureUsageBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="type,cancelURL,oname,otype"
        name="searchForm" 
        method="post"
        destination="/console/database/usage/search">

        <uix:formValue 
          name="pageName" 
          value="/database/usage/search/searchFeatureUsage"/>

        <uix:formValue name="searchType" value="tbsp"/>
        <uix:formValue name="event" value="doSearch"/>

        <uix:pageLayout
          titleBinding="SEARCH_FEATURE_USAGE_HEADER@dbFeatureUsageBundle@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <%--------------------
           -  Info Message Box
           ---------------------%>
          <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" mainTextKey="mainText"/>

          <%------------------------
           -  Error Handling
           ------------------------%>
          <oem:messageBox 
            errorTableBinding="errors@servletRequest" 
            messageType="error" 
            titleTextKey="titleText" mainTextKey="mainText" />

          <%-----------------------
           -  Instruction Section
           ------------------------%>
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat>
                <uix:rowLayout>

                  <uix:styledText 
                    styleClass="OraTipText"
                    textBinding="PAGE_REFRESHED@dbFeatureUsageBundle@servletRequest"/>

                  <uix:spacer width="5" />

                  <uix:styledText 
                    styleClass="OraTipLabel"
                    textBinding="pageTimeStamp@usageSearchBean@servletRequest"/>

                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <%------------------------
           -  Search Criteria
           ------------------------%>
          <%@ include file="/database/usage/search/searchCriteria.jspf" %>

          <%------------------------
           -  Search Results
           ------------------------%>
          <uix:header 
            textBinding="SEARCH_RESULTS_TEXT@dbFeatureUsageBundle@servletRequest"
            >

            <%------------------------
             -  Save to File
             ------------------------%>
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right" width="25%">
                <uix:submitButton 
                  name="event" 
                  textBinding="SAVE_TO_FILE_BUTTON_TEXT@dbFeatureUsageBundle@servletRequest"
                  disabledBinding="noSearchResults@usageSearchBean@servletRequest"
                  value="doSaveToFile"
                  />
              </uix:rowLayout>
            </uix:tableLayout>

            <%------------------------
             -  Feature Usage Table
             ------------------------%>
            <oem:table 
              summaryBinding="SEARCH_RESULTS_TEXT@dbFeatureUsageBundle@servletRequest"
              copyParams="type,cancelURL,oname,otype"
              width="100%" 
              blockSize="25"
              formSubmitted="true"
              name="searchResultsTable" 
              dataSourceProp="searchResultsTable"
              beanKey="usageSearchBean"
              alternateTextBinding="NO_RESULT_FOUND@dbFeatureUsageBundle@servletRequest"
              >
            </oem:table>

          </uix:header>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton 
                name="event" 
                textBinding="SEARCH_USING_SQL_BUTTON_TEXT@dbFeatureUsageBundle@servletRequest" 
                value="doSqlSearch" />

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>

