<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@usageBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="featureDrillForm" 
        method="post"
        destination="/console/database/usage">

        <uix:formValue 
          name="pageName" 
          value="/database/usage/usageFeatureDrilldown"/>

        <uix:pageLayout
          titleBinding="header@usageBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%-----------------------------
           -  Labeled Fields
           -----------------------------%>
          <uix:labeledFieldLayout width="75%" >

            <%------------------------
             -  Instance Name
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:switcher 
              childNameBinding="type@servletRequest">
              <uix:case name="oracle_database">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="INSTANCE_NAME@dbFeatureUsageBundle@servletRequest" />
              </uix:case>
            </uix:switcher>

            <%---  Field  ---%>
            <uix:switcher 
              childNameBinding="type@servletRequest">
              <uix:case name="oracle_database">
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="instanceName@usageBean@servletRequest"/>
              </uix:case>
            </uix:switcher>

            <%------------------------
             -  Version 
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="VERSION@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="version@usageBean@servletRequest"/>

            <%------------------------
             -  Feature Name
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="FEATURE_NAME@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="featureName@usageBean@servletRequest"/>

            <%------------------------
             -  Description
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="DESCRIPTION@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="description@usageBean@servletRequest"/>

            <%------------------------
             -  Detected Usages
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="DETECTED_USAGES@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="detectedUsages@usageBean@servletRequest"/>

            <%------------------------
             -  Total Samples
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="TOTAL_SAMPLES@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="totalSamples@usageBean@servletRequest"/>

            <%------------------------
             -  Currently Used
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="CURRENTLY_USED@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="currentlyUsed@usageBean@servletRequest"/>

            <%------------------------
             -  First Usage Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="FIRST_USAGE_DATE@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="firstUsageDate@usageBean@servletRequest"/>

            <%------------------------
             - Last Usage Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="LAST_USAGE_DATE@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="lastUsageDate@usageBean@servletRequest"/>

            <%------------------------
             -  Last Sample Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="LAST_SAMPLED_AT@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="lastSampleDate@usageBean@servletRequest"/>

            <%------------------------
             -  Next Sample Date
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="NEXT_SAMPLED_AT@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="nextSampleDate@usageBean@servletRequest"/>

            <%------------------------
             -  Last Sample Period
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:styledText
              styleClass="OraPromptText"
              textBinding="LAST_SAMPLE_PERIOD@dbFeatureUsageBundle@servletRequest" />

            <%---  Field  ---%>
            <uix:styledText
              styleClass="OraDataText"
              textBinding="lastSamplePeriod@usageBean@servletRequest"/>

            <%------------------------
             -  Aux Count
             ------------------------%>
            <%---  Prompt  ---%>
            <uix:switcher 
              childNameBinding="auxCountNull@usageBean@servletRequest">
              <uix:case name="false">
                <uix:styledText
                  styleClass="OraPromptText"
                  textBinding="COUNT@dbFeatureUsageBundle@servletRequest" />
              </uix:case>
            </uix:switcher>

            <%---  Field  ---%>
            <uix:switcher 
              childNameBinding="auxCountNull@usageBean@servletRequest">
              <uix:case name="false">
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="auxCount@usageBean@servletRequest"/>
              </uix:case>
            </uix:switcher>

          </uix:labeledFieldLayout>

          <%------------------------
           -  Feature Info
           ------------------------%>
          <uix:switcher 
            childNameBinding="featureInfoNull@usageBean@servletRequest">
            <uix:case name="false">

              <uix:header 
                textBinding="FEATURE_INFO@dbFeatureUsageBundle@servletRequest" 
                >
                <uix:rawText
                  preText="<listing>"
                  textBinding="featureInfo@usageBean@servletRequest"
                  postText="</listing>"
                  />
              </uix:header>

            </uix:case>
          </uix:switcher>

          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

              <uix:submitButton
                name="event" 
                textBinding="OK@uixDBObjectBundle@servletRequest"
                value="cancel"/>

            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
