<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@usageBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="featureUsageForm" 
        method="post"
        destination="/console/database/usage">

        <uix:formValue 
          name="pageName" 
          value="/database/usage/usageFeatureUsage"/>

        <uix:pageLayout
          titleBinding="header@usageBean@servletRequest"
          >

          <%@ include file="/database/global.jspf" %>

          <%-----------------------------------------
           -            Message Boxes               -
           -----------------------------------------%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <%@ include file="/database/usage/usageLabeledFieldsInc.jspf" %>

          <uix:subTabLayout>

            <%------------------------
             -  Subtabs
             ------------------------%>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
                <uix:link
                  textBinding="FEATURE_USAGE@dbFeatureUsageBundle@servletRequest" />
                <uix:link
                  textBinding="HIGH_WATER@dbFeatureUsageBundle@servletRequest"
                  onClick="submitForm('featureUsageForm', true, {event:'highWaterTab'})"/>
              </uix:subTabBar> 
            </uix:subTabs>

            <uix:tableLayout width="100%"> 
              <uix:rowLayout>

                <%------------------------
                 -  Introduction Text
                 ------------------------%>
                <uix:cellFormat hAlign="left">
                  <uix:styledText
                    styleClass="oraFieldText"
                    textBinding="FEATURE_USAGE_DESC@dbFeatureUsageBundle@servletRequest"/>    
                </uix:cellFormat>

              </uix:rowLayout>
            </uix:tableLayout> 

            <%------------------------
             -  Feature Usage Table
             ------------------------%>
            <oem:table 
              copyParams="target,type,cancelURL,oname,otype"
              summaryBinding="FEATURE_USAGE@dbFeatureUsageBundle@servletRequest"
              width="100%" 
              blockSize="25"
              formSubmitted="true"
              name="statisticsTable" 
              dataSourceProp="statisticsTable"
              beanKey="usageStatisticsBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>

          </uix:subTabLayout>

          <%@ include file="/database/usage/usageRelatedLinks.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
