<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head 
        titleBinding="title@usageBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="featureUsagePrintableForm" 
        method="post"
        destination="/console/database/usage">

        <uix:formValue 
          name="pageName" 
          value="/database/usage/usageFeatureUsagePrintable"/>

        <uix:pageLayout
          titleBinding="header@usageBean@servletRequest"
          >

          <uix:tableLayout width="100%"> 
            <uix:rowLayout>

              <%------------------------
               -  Introduction Text
               ------------------------%>
              <uix:cellFormat hAlign="left">
                <uix:styledText
                  styleClass="oraFieldText"
                  textBinding="FEATURE_USAGE_DESC@dbFeatureUsageBundle@servletRequest"/>    
              </uix:cellFormat>

            </uix:rowLayout>
          </uix:tableLayout> 

          <%@ include file="/database/usage/usageLabeledFieldsInc.jspf" %>

          <%------------------------
           -  Feature Usage Table
           ------------------------%>
          <uix:header 
            textBinding="USAGE_STATS@dbFeatureUsageBundle@servletRequest"
            >

            <oem:table 
              summaryBinding="USAGE_STATS@dbFeatureUsageBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSizeBinding="rowCount@usageStatisticsBean@servletRequest"
              formSubmitted="true"
              name="printableStatisticsTable" 
              dataSourceProp="printableStatisticsTable"
              beanKey="usageStatisticsBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>

          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
