<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@usageBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form 
        copyParams="target,type,cancelURL,oname,otype"
        name="highWaterPrintableForm" 
        method="post"
        destination="/console/database/usage">

        <uix:formValue 
          name="pageName" 
          value="/database/usage/usageHighWaterPrintable"/>

        <uix:pageLayout
          titleBinding="header@usageBean@servletRequest"
          >

          <%@ include file="/database/usage/usageLabeledFieldsInc.jspf" %>

          <%------------------------
           -  High Water Table
           ------------------------%>
          <uix:header 
            textBinding="HIGH_WATER@dbFeatureUsageBundle@servletRequest"
            >

            <oem:table 
              summaryBinding="HIGH_WATER@dbFeatureUsageBundle@servletRequest"
              copyParams="target,type,cancelURL,oname,otype"
              width="80%" 
              blockSizeBinding="rowCount@usageHighWaterBean@servletRequest"
              formSubmitted="true"
              name="printableHighWaterTable" 
              dataSourceProp="printableHighWaterTable"
              beanKey="usageHighWaterBean"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
            </oem:table>

          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

<%------------------------------  End of File  -------------------------------%>
