<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        step1.jsp
  -- Controller:  db/adm/util/AnalyzeController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
   <%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="WIZARD@uixAnalyzeBundle@servletRequest"/>
</uix:metaContainer>


<uix:body>
 <uix:contents>  
        <db:form name="analyze" method="post" destination="/console/database/util/analyze" copyParams="target,type">
          <uix:formValue name="pageName" value="/console/database/util/analyze/step1"/>
             <uix:pageLayout titleBinding="STEP1_HEADER@uixAnalyzeBundle@servletRequest">
             <%-- Oracle Logo and Tabs --%>
             <%@ include file="/database/global.jspf" %>
    
            <uix:location>
                <uix:train selectedIndex="0">
                    <uix:contents>
                        <uix:styledText textBinding="STEP1@uixAnalyzeBundle@servletRequest"/>
                        <uix:styledText textBinding="STEP2@uixAnalyzeBundle@servletRequest"/>
                        <uix:styledText textBinding="STEP3@uixAnalyzeBundle@servletRequest"/>
                        <uix:styledText textBinding="STEP4@uixAnalyzeBundle@servletRequest"/>
                        <uix:styledText textBinding="STEP5@uixAnalyzeBundle@servletRequest"/>
                    </uix:contents>
                </uix:train>
            </uix:location>

           <%-- Warning display --%>
           <oem:messageBox messageType="info" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
    
                        <uix:stackLayout>
                           <uix:contents>
                              <uix:spacer height="5"/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="STEP1_INTRO1@uixAnalyzeBundle@servletRequest"/>                                               
                              <uix:spacer height="10"/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="STEP1_INTRO2@uixAnalyzeBundle@servletRequest"/>
                              <uix:spacer height="5"/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="STEP1_INTRO3@uixAnalyzeBundle@servletRequest"/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="STEP1_INTRO4@uixAnalyzeBundle@servletRequest"/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="STEP1_INTRO5@uixAnalyzeBundle@servletRequest"/>
                              <uix:spacer height="10"/>
                              <uix:styledText styleClass="OraInstructionText" textBinding="STEP1_INTRO6@uixAnalyzeBundle@servletRequest"/>
                              <uix:spacer height="10"/>

                           </uix:contents>
                        </uix:stackLayout>
                  <uix:pageButtons>
                    <uix:pageButtonBar>
                       <uix:contents>
                          <uix:button name="done" destinationBinding="homePage@objectBean@servletRequest" textBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                          <uix:spacer width="5"/>
                                 <uix:navigationBar maxValue="5" minValue="1" name="analyzeNavigationBar" value="1"/>
                       </uix:contents>
                    </uix:pageButtonBar>
                  </uix:pageButtons>
            
</uix:pageLayout>
</db:form>
</uix:contents>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
