<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        step3E.jsp
  -- Controller:  db/adm/stg/AnalyzeController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="WIZARD@uixAnalyzeBundle@servletRequest"/>
</uix:metaContainer>

<%--
<%@ include file="/oemTitle.jspf" %>
--%>

<uix:body>
 <uix:contents>  

               <db:form name="analyzeStep3E" destination="/console/database/util/analyze" copyParams="target,type">

                     <uix:formValue name="pageName" value="/database/util/analyze/step3e"/>
             <uix:pageLayout titleBinding="STEP3E_GATHER_METHOD@uixAnalyzeBundle@servletRequest">

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
  
  
<%--                     <uix:header textBinding="optionsHeader@objectBean@servletRequest"/>
 --%>

                  <uix:stackLayout>
                     <uix:contents>
                        <uix:spacer height="5"/>

            <uix:header textBinding="STEP3E_GATHER_METHOD@uixAnalyzeBundle@servletRequest" size="2">
                              <uix:rowLayout>
                                  <uix:contents>
                              <oem:radioButton name="currentMethodSelected" value="1" selectedValueBinding="currentMethodSelected@objectBean@servletRequest" textBinding="STEP2_DEFAULT_OPTION1@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>

                              <uix:rowLayout>
                                  <uix:contents>
                              <oem:radioButton name="currentMethodSelected" value="2" selectedValueBinding="currentMethodSelected@objectBean@servletRequest" textBinding="STEP2_DEFAULT_OPTION2@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>
                        
                               <uix:switcher childNameBinding="ifVersion9OrHigher@objectBean@servletRequest">
                                    <uix:case name="true">
                                         <uix:rowLayout>
                                              <uix:contents>
                                                 <uix:spacer width="20"/>
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="STEP2_ESTIMATE@uixAnalyzeBundle@servletRequest"/>                      
                                              </uix:contents>
                                        </uix:rowLayout>
                                    </uix:case>
                                </uix:switcher>

                                
                                <uix:switcher childNameBinding="ifVersion9OrHigher@objectBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                          <uix:contents>
                                             <uix:spacer width="10"/>
                                             <uix:spacer width="10"/>
                                             <uix:spacer width="10"/>
                                             <oem:radioButton name="currentEstimateSelected" value="1" selectedValueBinding="currentEstimateSelected@objectBean@servletRequest" textBinding="STEP2_ESTIMATE_DEFAULTED@uixAnalyzeBundle@servletRequest"/>
                                          </uix:contents>
                                       </uix:rowLayout>
                                  </uix:case>
                                </uix:switcher>

                              <uix:switcher childNameBinding="ifVersion9OrHigher@objectBean@servletRequest">
                                    <uix:case name="true">
                                         <uix:rowLayout>
                                            <uix:contents>
                                               <uix:spacer width="10"/>
                                               <uix:spacer width="10"/>
                                               <uix:spacer width="10"/>
                                               <oem:radioButton name="currentEstimateSelected" value="2" selectedValueBinding="currentEstimateSelected@objectBean@servletRequest" textBinding="STEP2_ESTIMATE_DEFINED@uixAnalyzeBundle@servletRequest"/>
                                               <uix:spacer width="5"/>
                                               <uix:textInput name="currentEstimate" textBinding="currentEstimate@objectBean@servletRequest" readOnly="false" maximumLength="10" columns="10" shortDescBinding="STEP2_ESTIMATE@uixAnalyzeBundle@servletRequest"/>
                                               <uix:spacer width="5"/>
                                               <uix:messageText messageBinding="PercentageUnchanged@errors@servletRequest" messageType="warning"/>
                                            </uix:contents>
                                         </uix:rowLayout>

                                      </uix:case>
                                      <uix:default>
                                          <uix:rowLayout>
                                            <uix:contents>
                                               <uix:spacer width="10"/>
                                               <uix:spacer width="10"/>
                                               <uix:styledText styleClass="OraInstructionText" textBinding="STEP2_ESTIMATE@uixAnalyzeBundle@servletRequest"/>                      
                                               <uix:spacer width="5"/>
                                               <uix:textInput name="currentEstimate" textBinding="currentEstimate@objectBean@servletRequest" readOnly="false" maximumLength="10" columns="10" shortDescBinding="STEP2_ESTIMATE@uixAnalyzeBundle@servletRequest"/>
                                               <uix:spacer width="5"/>
                                               <uix:messageText messageBinding="PercentageUnchanged@errors@servletRequest" messageType="warning"/>
                                            </uix:contents>
                                         </uix:rowLayout>
                                      </uix:default>
                              </uix:switcher>
                  
                              
                              <uix:rowLayout>
                                  <uix:contents>
                                     <uix:spacer width="20"/>
                                        <uix:styledText styleClass="OraInstructionText" textBinding="STEP3E_SAMPLING@uixAnalyzeBundle@servletRequest"/>                      
                                  </uix:contents>
                               </uix:rowLayout>

                              <uix:rowLayout>
                                  <uix:contents>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <oem:radioButton name="currentSamplingSelected" value="1" selectedValueBinding="currentSamplingSelected@objectBean@servletRequest" textBinding="STEP2_ROW_SAMPLING@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>

                               <uix:rowLayout>
                                  <uix:contents>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <oem:radioButton name="currentSamplingSelected" value="2" selectedValueBinding="currentSamplingSelected@objectBean@servletRequest" textBinding="STEP2_BLOCK_SAMPLING@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>

                              <oem:radioButton name="currentMethodSelected" value="3" selectedValueBinding="currentMethodSelected@objectBean@servletRequest" textBinding="STEP2_DEFAULT_OPTION3@uixAnalyzeBundle@servletRequest"/>
                           </uix:header>   

                           <uix:switcher childNameBinding="ifGatherOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">
            <uix:header textBinding="STEP3E_GATHER_OPTION@uixAnalyzeBundle@servletRequest" size="2">
              <uix:tableLayout>
                           <uix:switcher childNameBinding="ifVersion9OrHigher@objectBean@servletRequest">
                              <uix:case name="true">
                                 <uix:switcher childNameBinding="ifGatherOptionApplies@objectBean@servletRequest">
                                    <uix:case name="true">
                                    <uix:rowLayout>
                                        <uix:contents>
                                           <oem:radioButton name="currentGatheringSelected" value="1" selectedValueBinding="currentGatheringSelected@objectBean@servletRequest" textBinding="STEP3E_GATHER_AUTO@uixAnalyzeBundle@servletRequest"/>
                                        </uix:contents>
                                     </uix:rowLayout>
                                    </uix:case>
                                  </uix:switcher>
                              </uix:case>
                            </uix:switcher>

                           <uix:switcher childNameBinding="ifGatherOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:contents>
                                     <oem:radioButton name="currentGatheringSelected" value="2" selectedValueBinding="currentGatheringSelected@objectBean@servletRequest" textBinding="STEP3E_GATHER_STALE@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher> 

                           <uix:switcher childNameBinding="ifGatherOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:contents>
                                     <oem:radioButton name="currentGatheringSelected" value="3" selectedValueBinding="currentGatheringSelected@objectBean@servletRequest" textBinding="STEP3E_GATHER_EMPTY@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher> 

                           <uix:switcher childNameBinding="ifGatherOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:contents>
                                     <uix:switcher childNameBinding="ifSchemaCurrent@objectBean@servletRequest">
                                        <uix:case name="true">
                                           <oem:radioButton name="currentGatheringSelected" value="4" selectedValueBinding="currentGatheringSelected@objectBean@servletRequest" textBinding="STEP3E_GATHER_SCHEMA@uixAnalyzeBundle@servletRequest"/>
                                        </uix:case>
                                     </uix:switcher> 
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher> 

                           <uix:switcher childNameBinding="ifGatherOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:contents>
                                     <uix:switcher childNameBinding="ifSchemaCurrent@objectBean@servletRequest">
                                        <uix:case name="false">
                                           <oem:radioButton name="currentGatheringSelected" value="4" selectedValueBinding="currentGatheringSelected@objectBean@servletRequest" textBinding="STEP3E_GATHER_DATABASE@uixAnalyzeBundle@servletRequest"/>
                                        </uix:case>
                                     </uix:switcher> 
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher> 

                            </uix:tableLayout>
                        </uix:header>
                              </uix:case>
                           </uix:switcher> 

                           <uix:switcher childNameBinding="ifCascadeOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">
            <uix:header textBinding="STEP3E_ADVANCED_OPTION@uixAnalyzeBundle@servletRequest" size="2">

                           <uix:switcher childNameBinding="ifCascadeOptionApplies@objectBean@servletRequest">
                              <uix:case name="true">

                                 <uix:rowLayout>
                                       <uix:checkBox name="currentCascadeApplied" textBinding="STEP3E_CASCADE_OPTION@uixAnalyzeBundle@servletRequest" styleClass="OraPromptText" checkedBinding="currentCascadeApplied@objectBean@servletRequest"/>
                                 </uix:rowLayout>

                              </uix:case>
                           </uix:switcher>

                           <uix:switcher childNameBinding="ifDegreeApplies@objectBean@servletRequest">
                              <uix:case name="true">

                                 <uix:rowLayout>
                                        <uix:checkBox name="currentDegreeApplied" textBinding="STEP3E_IN_PARALLEL@uixAnalyzeBundle@servletRequest" styleClass="OraPromptText" checkedBinding="currentDegreeApplied@objectBean@servletRequest"/>
                                 </uix:rowLayout>

                              </uix:case>
                           </uix:switcher>

                           <uix:switcher childNameBinding="ifDegreeApplies@objectBean@servletRequest">
                              <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:contents>
                                     <uix:spacer width="20"/>
                                        <uix:styledText styleClass="OraInstructionText" textBinding="STEP3E_DEGREE@uixAnalyzeBundle@servletRequest"/>                      
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher>

                           <uix:switcher childNameBinding="ifDegreeApplies@objectBean@servletRequest">
                              <uix:case name="true">
                              <uix:rowLayout>
                                  <uix:contents>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <oem:radioButton name="currentDegreeSelected" value="1" selectedValueBinding="currentDegreeSelected@objectBean@servletRequest" textBinding="STEP3E_DEGREE_DEFAULTED@uixAnalyzeBundle@servletRequest"/>
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher>

                           <uix:switcher childNameBinding="ifDegreeApplies@objectBean@servletRequest">
                              <uix:case name="true">
                               <uix:rowLayout>
                                  <uix:contents>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <uix:spacer width="10"/>
                                     <oem:radioButton name="currentDegreeSelected" value="2" selectedValueBinding="currentDegreeSelected@objectBean@servletRequest" textBinding="STEP3E_DEGREE_DEFINED@uixAnalyzeBundle@servletRequest"/>
                                     <uix:spacer width="5"/>
                                     <uix:textInput name="currentDegree" textBinding="currentDegree@objectBean@servletRequest" readOnly="false" maximumLength="10" columns="10" shortDescBinding="STEP3E_DEGREE_DEFINED@uixAnalyzeBundle@servletRequest">
                                     </uix:textInput>
                                     <uix:spacer width="5"/>
                                     <uix:messageText messageBinding="DegreeUnchanged@errors@servletRequest" messageType="warning"/>
                                  </uix:contents>
                               </uix:rowLayout>
                              </uix:case>
                           </uix:switcher>
                               



                         <uix:tableLayout cellSpacing="5">
                           <uix:switcher childNameBinding="ifScopeApplies@objectBean@servletRequest">
                              <uix:case name="true">

                                 <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                       <uix:styledText textBinding="STEP3E_SCOPE@uixAnalyzeBundle@servletRequest" styleClass="OraPromptText" labeledNodeId="currentScope"/>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                       <oem:choice id="currentScope" name="currentScope" optionsBinding="scopes@objectBean@servletRequest" selectedValueBinding="currentScope@objectBean@servletRequest"/>
                                    </uix:cellFormat>
                                 </uix:rowLayout>

                              </uix:case>
                           </uix:switcher>

                           <uix:switcher childNameBinding="ifGranularityApplies@objectBean@servletRequest">
                              <uix:case name="true">

                                 <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                       <uix:styledText textBinding="STEP3E_GRANULARITY@uixAnalyzeBundle@servletRequest" styleClass="OraPromptText" labeledNodeId="currentGranularity"/>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                       <oem:choice id="currentGranularity" name="currentGranularity" optionsBinding="granularities@objectBean@servletRequest" selectedValueBinding="currentGranularity@objectBean@servletRequest"/>
                                    </uix:cellFormat>
                                 </uix:rowLayout>

                              </uix:case>
                           </uix:switcher>


                        </uix:tableLayout>
                    </uix:header>
                              </uix:case>
                           </uix:switcher>

                   <uix:header>
                        <uix:rowLayout>
                           <uix:checkBox name="default" textBinding="applyClause@objectBean@servletRequest"/>
                           <%--<uix:textInput name="applyClause" textBinding="applyClause@objectBean@servletRequest" readOnly="true" maximumLength="10" columns="10"/> --%>
                        </uix:rowLayout>
                   </uix:header>

                     </uix:contents>
                  </uix:stackLayout>

                  <uix:pageButtons>
                     <uix:pageButtonBar>
                        <uix:contents>

                           <uix:rowLayout>
                              <uix:contents>
                                 <uix:submitButton name="event" value="cancel" textBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                                 <uix:spacer width="5"/>
                                 <uix:submitButton name="event" value="edit" textBinding="OK@uixDBObjectBundle@servletRequest"/>
                              </uix:contents>
                           </uix:rowLayout>

                        </uix:contents>
                     </uix:pageButtonBar>
                  </uix:pageButtons>
                  
               </uix:pageLayout>

            </db:form>
         </uix:contents>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
